/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.server;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.etc.model.EtcWord;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.xdts.common.XdtsSqlParser;
import jp.co.extreme.module.xdts.common.XdtsWordUtil;
import jp.co.extreme.module.xdts.model.XysWordContext;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v001.XdtsSelectColumn;
import jp.co.extreme.module.xdts.model.v001.XdtsSelectContext;
import jp.co.extreme.poi.PoiCsvWriter4Table;
import jp.co.extreme.poi.PoiExportCondition;
import jp.co.extreme.poi.PoiUtil;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class XdtsTempProc
extends BcLoggableObject {
    public Map<String, String> viewColumnMap = new HashMap<String, String>();

    public void createCsvFile(BcTableModel tableModel, File destFile) throws Exception {
        PoiExportCondition exportCondition = PoiUtil.createExportCondition();
        PoiCsvWriter4Table csvWriter4Table = new PoiCsvWriter4Table();
        BcFileUtil.deleteIfExists(destFile);
        csvWriter4Table.writeTable(exportCondition, tableModel.getTableColumnModel(), tableModel, destFile);
    }

    public void getViewInfo(SqlConnection sqlConn) throws Exception {
        SqlContext sqlContext = sqlConn.getSqlContext();
        List<String> viewNameList = sqlContext.getViewNameList(sqlConn);
        int i = 0;
        while (i < viewNameList.size()) {
            String viewName = viewNameList.get(i);
            this.getViewInfo(sqlConn, viewName);
            ++i;
        }
        this.getLogger().debug("viewColumnMap.size()=" + this.viewColumnMap.size());
    }

    public void getViewInfo(SqlConnection sqlConn, String viewName) throws Exception {
        String definition = this.getViewDefinition(sqlConn, viewName);
        XdtsSqlParser sqlParser = new XdtsSqlParser();
        XdtsExtractionCondition extractionCondition = sqlParser.createExtractionCondition(definition);
        int i = 0;
        while (i < extractionCondition.selectContextList.size()) {
            XdtsSelectContext selectContext = extractionCondition.selectContextList.get(i);
            int j = 0;
            while (j < selectContext.selectColumnList.size()) {
                XdtsSelectColumn selectColumn = selectContext.selectColumnList.get(j);
                String[] strArray = MmdUtil.splitTableColumnName(selectColumn.tableColumnName.orign);
                String viewColumnName = MmdUtil.createTableColumnName(viewName, strArray[1]);
                this.viewColumnMap.put(viewColumnName, strArray[0].toLowerCase());
                ++j;
            }
            ++i;
        }
    }

    public String getViewDefinition(SqlConnection sqlConn, String viewName) throws Exception {
        SqlContext sqlContext = sqlConn.getSqlContext();
        String query = "SELECT definition FROM pg_views WHERE viewname " + sqlContext.toCondition_string("=", viewName);
        this.getLogger().debug("query=" + query);
        String definition = null;
        try (SqlStatement stmt = sqlConn.createStatement();){
            ResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                definition = rs.getString(1);
            }
            rs.close();
        }
        return definition;
    }

    public List<EtcWord> toEtcWordList(Map<String, Map<String, String>> wordMap, Map<String, Map<String, MmdField>> mmdFieldMap, int profileId) throws Exception {
        ArrayList<EtcWord> etcWordList = new ArrayList<EtcWord>();
        for (Map.Entry<String, Map<String, String>> mapEntry1 : wordMap.entrySet()) {
            Map<String, String> wordMap2 = mapEntry1.getValue();
            Map<String, MmdField> mmdFieldMap2 = mmdFieldMap.get(mapEntry1.getKey());
            for (Map.Entry<String, String> mapEntry2 : wordMap2.entrySet()) {
                EtcWord etcWord = new EtcWord();
                etcWord.profileId = profileId;
                etcWord.code = mapEntry1.getKey();
                etcWord.lang = mapEntry2.getKey();
                etcWord.value = mapEntry2.getValue();
                MmdField mmdField = mmdFieldMap2.get(etcWord.lang);
                if (mmdField == null) {
                    mmdField = new MmdField();
                }
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(mmdField.decimalDigit);
                row.add(mmdField.columnCount);
                row.add(mmdField.valueConverterClassName);
                row.add(mmdField.fieldDisplay.formatStr);
                row.add(mmdField.fieldDisplay.displayClassName);
                row.add(mmdField.fieldDisplay.horizonalAlignment);
                row.add(mmdField.fieldDisplay.renderingConverterClassName);
                row.add(mmdField.fieldDisplay.shift);
                etcWord.note = BcCsvUtil.toCsv(row);
                etcWordList.add(etcWord);
            }
        }
        return etcWordList;
    }

    public void setWords(List<EtcWord> etcWordList, Map<String, Map<String, String>> wordMap, Map<String, Map<String, MmdField>> mmdFieldMap) throws Exception {
        int i = 0;
        while (i < etcWordList.size()) {
            EtcWord etcWord = etcWordList.get(i);
            HashMap<String, String> wordMap2 = new HashMap<String, String>();
            wordMap2.put(etcWord.lang, etcWord.value);
            wordMap.put(etcWord.code, wordMap2);
            List<String> row = BcCsvUtil.parseCsvRow(etcWord.note, true);
            BcCollectionUtil.fill(row, 8);
            MmdField mmdField = new MmdField();
            mmdField.decimalDigit = BcNumberUtil.parseInteger(row.get(0), -1);
            mmdField.columnCount = BcNumberUtil.parseInteger(row.get(1), -1);
            mmdField.valueConverterClassName = row.get(2);
            mmdField.fieldDisplay.formatStr = row.get(3);
            mmdField.fieldDisplay.displayClassName = row.get(4);
            mmdField.fieldDisplay.horizonalAlignment = BcNumberUtil.parseInteger(row.get(5), MmdUtil.Alignment.NULL.id);
            mmdField.fieldDisplay.renderingConverterClassName = row.get(6);
            mmdField.fieldDisplay.shift = BcNumberUtil.parseInteger(row.get(7), 0);
            XdtsWordUtil.setupMmdField(mmdField);
            HashMap<String, MmdField> mmdFieldMap2 = new HashMap<String, MmdField>();
            mmdFieldMap2.put(etcWord.lang, mmdField);
            mmdFieldMap.put(etcWord.code, mmdFieldMap2);
            ++i;
        }
    }

    public void test1(DtsSessionFactory dtsSessionFactory) throws Exception {
        File dir = new File("X:/ext_develop/ews_ext_g40/63_91_11_test");
        File inputFile = new File(dir, "nls_words_new.json");
        String jsonStr = BcFileUtil.readAsString(inputFile, BcConstants.charset);
        List wordContextList = (List)JacksonUtil.getObjectMapper().readValue(jsonStr, (TypeReference)new TypeReference<List<XysWordContext>>(){});
        ArrayList<EtcWord> etcWordList = new ArrayList<EtcWord>();
        ArrayList<MmdField> mmdFieldList = new ArrayList<MmdField>();
        BcLogUtil.debug("wordContextList.size()=" + wordContextList.size());
        int i = 0;
        while (i < wordContextList.size()) {
            XysWordContext wordContext = (XysWordContext)wordContextList.get(i);
            mmdFieldList.add(wordContext.field);
            for (Map.Entry<String, String> mapEntry : wordContext.map.entrySet()) {
                EtcWord etcWord = new EtcWord();
                etcWord.code = wordContext.wordCode;
                etcWord.lang = mapEntry.getKey();
                etcWord.value = mapEntry.getValue();
                etcWordList.add(etcWord);
            }
            ++i;
        }
        DtsWordManagerImpl wordManager = (DtsWordManagerImpl)dtsSessionFactory.wordManager;
        this.setWords(etcWordList, wordManager.wordMap, dtsSessionFactory.mmdFieldMap);
        BcTableModel tableModel = XdtsWordUtil.createTable(wordManager.wordMap, dtsSessionFactory.mmdFieldMap);
        File destFile = new File(dir, "nls_words.csv");
        this.createCsvFile(tableModel, destFile);
    }
}

