/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.rmo;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.module.xdts.dao.XdtsTaskDAO;
import jp.co.extreme.module.xdts.dao.XdtsTimerDAO;
import jp.co.extreme.module.xdts.model.XdtsTask;
import jp.co.extreme.module.xdts.model.XdtsTimer;
import jp.co.extreme.module.xdts.server.XdtsSessionFactoryManager;
import jp.co.extreme.orm.dao.OrmSequenceDAO;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;

public class XdtsTimerRMO
extends RmiAbstractRMO {
    public void putTimer(RmiRmoArgument rmoArg) throws Exception {
        XdtsTimer timer = (XdtsTimer)rmoArg.getRequest().getData();
        List taskList = (List)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsTimerDAO.getInstance().putEntity(dtsSession, timer);
        int i = 0;
        while (i < taskList.size()) {
            XdtsTask task = (XdtsTask)taskList.get(i);
            task.timerId = timer.getDataId();
            XdtsTaskDAO.getInstance().putEntity(dtsSession, task);
            ++i;
        }
        this.setSchedule(timer, taskList);
        rmoArg.getRespons().addData(timer);
    }

    public void getTimer(RmiRmoArgument rmoArg) throws Exception {
        int timerId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsTimer timer = XdtsTimerDAO.getInstance().getTimer(dtsSession, timerId);
        rmoArg.getRespons().addData(timer);
    }

    public void deleteTimer(RmiRmoArgument rmoArg) throws Exception {
        int timerId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsTimer timer = new XdtsTimer();
        timer.setDataId(timerId);
        int cnt = XdtsTimerDAO.getInstance().deleteEntity(dtsSession, timer);
        rmoArg.getRespons().addData(cnt);
    }

    public void getTimerList(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        List<XdtsTimer> timerList = XdtsTimerDAO.getInstance().getTimerList(dtsSession);
        rmoArg.getRespons().addData(timerList);
    }

    public void createTimerName(RmiRmoArgument rmoArg) throws Exception {
        XdtsTimer timer;
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        SqlContext sqlContext = dtsSession.getSqlContext();
        long sequenceNumber = OrmSequenceDAO.getInstance().getNumber(dtsSession.getConnection(), sqlContext, "xdts_timer.id", true);
        String timerName = null;
        do {
            timerName = "timer-" + ++sequenceNumber;
        } while ((timer = XdtsTimerDAO.getInstance().getTimerByName(dtsSession, timerName)) != null);
        rmoArg.getRespons().addData(timerName);
    }

    public void setSchedule(XdtsTimer timer, List<XdtsTask> taskList) throws Exception {
        BcLogUtil.debug("triggerId=" + timer.triggerId);
        int n = 0;
        switch (timer.triggerId) {
            case 11: {
                n = 1;
                break;
            }
            case 12: {
                n = 1000;
            }
        }
        long initialDelay = timer.startTime.getTimeInMillis() - System.currentTimeMillis();
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long intervalMillis = BcNumberUtil.parseLong(timer.value1, -1) * (long)n;
        long executionCountMax = BcNumberUtil.parseLong(timer.value2, -1);
        BcLogUtil.debug("initialDelay=" + initialDelay + " intervalMillis=" + intervalMillis + " executionCountMax=" + executionCountMax);
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        InnerRunnable runnable = new InnerRunnable(executorService, taskList);
        runnable.executionCountMax = executionCountMax;
        ScheduledFuture<?> future = executorService.scheduleAtFixedRate(runnable, initialDelay, intervalMillis, TimeUnit.MILLISECONDS);
    }

    protected void submitTaskList(List<XdtsTask> taskList) throws Exception {
        int i = 0;
        while (i < taskList.size()) {
            XdtsTask task = taskList.get(i);
            try {
                this.submitTask(task);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            ++i;
        }
    }

    protected void submitTask(XdtsTask task) throws Exception {
        BcLogUtil.debug("task.getDataId()=" + task.getDataId() + " task.profileId=" + task.profileId);
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
        DtsSession dtsSession = dtsSessionFactory.createSession(this);
        try {
            try {
                DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, task.profileId);
                DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);
                try {
                    Object res = SqlUtil.execute(dtsSessionWk1.getConnection(), task.query);
                    BcLogUtil.debug("res=" + res);
                }
                finally {
                    dtsSessionWk1.desturuct();
                }
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                dtsSession.desturuct();
            }
        }
        finally {
            dtsSession.desturuct();
        }
    }

    protected class InnerRunnable
    implements Runnable {
        ExecutorService executorService;
        List<XdtsTask> taskList;
        long executionCount;
        long executionCountMax;

        public InnerRunnable(ExecutorService executorService, List<XdtsTask> taskList) {
            this.executorService = executorService;
            this.taskList = taskList;
        }

        @Override
        public void run() {
            ++this.executionCount;
            BcLogUtil.debug("executionCount=" + this.executionCount);
            try {
                XdtsTimerRMO.this.submitTaskList(this.taskList);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            if (this.executionCountMax > 0L && this.executionCount >= this.executionCountMax && !this.executorService.isShutdown()) {
                BcLogUtil.debug("executorService.shutdown");
                this.executorService.shutdown();
            }
        }
    }
}

