/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.rmo;

import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbfw.common.WbfSiteContext;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.server.HttpServerProcess;
import jp.co.extreme.module.xdts.server.XdtsServerUtil;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf5.dao.ScfAbstractIntPropertyDAO;
import jp.co.extreme.scf5.dao.ZScfPropertyDAOManager;
import jp.co.extreme.scf5.model.ZScfIntProperties;

public class XdtsHttpServerRMO
extends RmiAbstractRMO {
    public void getSiteContext(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScfAbstractIntPropertyDAO propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(XdtsConstants.TableName.xdts_property.name());
        ZScfIntProperties intProps = propertyDAO2.getPropertyAsIntProps(dtsSession);
        String hostName = intProps.get(XdtsConstants.Property.hostName.id);
        String port = intProps.get(XdtsConstants.Property.port.id);
        String siteName = intProps.get(XdtsConstants.Property.siteName.id);
        hostName = BcStringUtil.choiceNotNull(hostName, "localhost");
        port = BcStringUtil.choiceNotNull(port, "80");
        siteName = BcStringUtil.choiceNotNull(siteName, "DB Tool");
        intProps.clear();
        intProps.put((Integer)XdtsConstants.Property.hostName.id, hostName);
        intProps.put((Integer)XdtsConstants.Property.port.id, port);
        propertyDAO2.putPropertyElement(dtsSession, intProps);
        WbfSiteContext siteContext = new WbfSiteContext();
        siteContext.propertyMap.put(XdtsConstants.Property.hostName.name(), hostName);
        siteContext.propertyMap.put(XdtsConstants.Property.port.name(), port);
        siteContext.siteName = siteName;
        rmoArg.getRespons().addData(siteContext);
    }

    public void start(RmiRmoArgument rmoArg) throws Exception {
        WbfSiteContext siteContext = (WbfSiteContext)rmoArg.getRequest().getData();
        String hostName = siteContext.propertyMap.get(XdtsConstants.Property.hostName.name());
        String port = siteContext.propertyMap.get(XdtsConstants.Property.port.name());
        ZScfIntProperties intProps = new ZScfIntProperties();
        intProps.put((Integer)XdtsConstants.Property.hostName.id, hostName);
        intProps.put((Integer)XdtsConstants.Property.port.id, port);
        intProps.put((Integer)XdtsConstants.Property.siteName.id, siteContext.siteName);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScfAbstractIntPropertyDAO propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(XdtsConstants.TableName.xdts_property.name());
        propertyDAO2.putPropertyElement(dtsSession, intProps);
        dtsSession.commit();
        siteContext.servletPathMap.clear();
        HttpServerProcess httpServerProcess = XdtsServerUtil.getInstance().getHttpServer();
        this.getLogger().debug("httpServerProcess=" + httpServerProcess);
        httpServerProcess.start(siteContext);
        BcResult result = new BcResult();
        rmoArg.getRespons().addData(result);
    }

    public void stop(RmiRmoArgument rmoArg) throws Exception {
        HttpServerProcess httpServerProcess = XdtsServerUtil.getInstance().getHttpServer();
        this.getLogger().debug("httpServerProcess=" + httpServerProcess);
        httpServerProcess.stop();
        BcResult result = new BcResult();
        rmoArg.getRespons().addData(result);
    }

    public static enum Method implements RmiRemoteMethod
    {
        getSiteContext,
        start,
        stop;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

