/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxDateTimePane;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.fx.XdtsTriggerComboBox;
import jp.co.extreme.module.xdts.model.XdtsTimer;
import jp.co.extreme.module.xdts.stub.XdtsTimerStub;
import jp.co.extreme.scf.scheduler.ScfSchedulerWords;

class XdtsTimerPane
extends FxBorderPane {
    FxFlowPane topPane = new FxFlowPane(11);
    FxTextField nameTextField = new FxTextField();
    FxDateTimePane dateTimePane = new FxDateTimePane(2);
    XdtsTriggerComboBox triggerComboBox = new XdtsTriggerComboBox();
    FxFlowPane cennterPane = new FxFlowPane(11);
    FxTextField value1TextField = new FxTextField();
    FxTextField value2TextField = new FxTextField();
    FxTextField value3TextField = new FxTextField();
    FxTextField value4TextField = new FxTextField();
    XdtsTimer timer;

    public XdtsTimerPane() throws Exception {
        this.triggerComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue ov, String oldValue, String newValue) {
                try {
                    XdtsTimerPane.this.timer.triggerId = XdtsTimerPane.this.triggerComboBox.getTriggerId();
                    switch (XdtsTimerPane.this.timer.triggerId) {
                        case 11: {
                            XdtsTimerPane.this.setComponent_milliSecond();
                            break;
                        }
                        case 12: {
                            XdtsTimerPane.this.setComponent_second();
                            break;
                        }
                        case 21: {
                            XdtsTimerPane.this.setComponent_daily();
                        }
                    }
                }
                catch (Exception ex) {
                    XdtsTimerPane.this.handleException(ex);
                }
            }
        });
        this.setTopComponent();
    }

    protected void setTopComponent() throws Exception {
        this.nameTextField.setPrefColumnCount(40);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().name), new Node[]{this.nameTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.dateTimePane.setPrefWidth(300.0);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().start), new Node[]{this.dateTimePane});
        this.topPane.addNodeUnit(nodeUnit);
        this.dateTimePane.setCalendar(BcTimeUtil.createCalendar());
        this.triggerComboBox.setPrefSize(100.0, 24.0);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(ScfSchedulerWords.getInstance().trigger), new Node[]{this.triggerComboBox});
        this.topPane.addNodeUnit(nodeUnit);
        this.topPane.setPrefHeight(80.0);
        this.setTop((Node)this.topPane);
    }

    protected void setComponent_milliSecond() throws Exception {
        this.cennterPane.nodeUnitList.clear();
        this.value1TextField.setPrefColumnCount(10);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel("Interval(millis)"), new Node[]{this.value1TextField});
        this.cennterPane.addNodeUnit(nodeUnit);
        this.value2TextField.setPrefColumnCount(10);
        nodeUnit = new FxNodeUnit((Node)new FxLabel("Max Number of executions"), new Node[]{this.value2TextField});
        this.cennterPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.cennterPane);
        this.setPrefSize(860.0, 140.0);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setComponent_second() throws Exception {
        this.cennterPane.nodeUnitList.clear();
        this.value1TextField.setPrefColumnCount(10);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel("Interval(Sec.)"), new Node[]{this.value1TextField});
        this.cennterPane.addNodeUnit(nodeUnit);
        this.value2TextField.setPrefColumnCount(10);
        nodeUnit = new FxNodeUnit((Node)new FxLabel("Max Number of executions"), new Node[]{this.value2TextField});
        this.cennterPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.cennterPane);
        this.setPrefSize(860.0, 140.0);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setComponent_daily() throws Exception {
        this.cennterPane.nodeUnitList.clear();
        this.value1TextField.setPrefColumnCount(10);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel("Interval(day)"), new Node[]{this.value1TextField});
        this.cennterPane.addNodeUnit(nodeUnit);
        this.value2TextField.setPrefColumnCount(10);
        nodeUnit = new FxNodeUnit((Node)new FxLabel("Max \ufeffNumber of executions"), new Node[]{this.value2TextField});
        this.cennterPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.cennterPane);
        this.setPrefSize(860.0, 140.0);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setData(XdtsTimer timer) throws Exception {
        this.timer = timer;
        this.nameTextField.setText(timer.name);
        if (timer.getDataId() <= 0 && BcStringUtil.isEmpty(this.nameTextField.getText())) {
            this.nameTextField.setText(XdtsTimerStub.getInstance().createTimerName());
        }
        this.dateTimePane.setCalendar(timer.startTime);
        this.triggerComboBox.setTriggerId(timer.triggerId);
        this.value1TextField.setText(timer.value1);
        this.value2TextField.setText(timer.value2);
    }

    public void storeData(XdtsTimer timer) throws Exception {
        timer.name = this.nameTextField.getText();
        timer.startTime = this.dateTimePane.getCalendar();
        timer.triggerId = this.triggerComboBox.getTriggerId();
        timer.value1 = this.value1TextField.getText();
        timer.value2 = this.value2TextField.getText();
    }

    public BcResult validate() throws Exception {
        XdtsTimer timer = new XdtsTimer();
        this.storeData(timer);
        BcResult result = new BcResult();
        switch (timer.triggerId) {
            case 11: {
                BcInputValidator.getInstance().notNullable(timer.value1, "Interval(sec.)", result.getErrorList());
            }
        }
        return result;
    }
}

