/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.model.XdtsSchemaObject;
import jp.co.extreme.module.xdts.model.XdtsSchemaObjectTableModel;

class XdtsSchemaObjectSelectionPane
extends FxDecoratePane {
    XdtsSchemaObjectTableModel schemaObjectTableModel;
    FxTableView tableView;
    Button selectAllBbutton;
    Button releaseAllButton;

    public XdtsSchemaObjectSelectionPane() throws Exception {
        this.selectAllBbutton = this.createButton(BcWords.getInstance().selectAll.toPlain());
        this.releaseAllButton = this.createButton(BcWords.getInstance().releaseAll.toPlain());
        FxUtil.setPrefSize((Node)this.releaseAllButton);
    }

    public void setSchemaObjectList(List<XdtsSchemaObject> schemaObjectList) throws Exception {
        this.schemaObjectTableModel = new XdtsSchemaObjectTableModel();
        this.schemaObjectTableModel.tableContextList = schemaObjectList;
        FxTableRowList tableRowList = new FxTableRowList(this.schemaObjectTableModel);
        BcTableColumnModel tableColumnModel = this.createTableColumnModel();
        this.tableView = new InnerTableView();
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        FxTableUtil.createColumn(tableColumnModel, this.tableView, null);
        this.tableView.setItems(tableRowList);
        this.tableView.setEditable(true);
        this.setCenter((Node)this.tableView);
    }

    protected BcTableColumnModel createTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = XdtsWords.getInstance().schemaObject;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 28;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().type;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 6;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().select;
        mmdField.dataClass = Boolean.class;
        mmdField.columnCount = 6;
        mmdField.fieldDisplay.horizonalAlignment = 0;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = true;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.selectAllBbutton) {
            this.setEenabledAll(true);
        } else if (ev.getSource() == this.releaseAllButton) {
            this.setEenabledAll(false);
        }
    }

    protected void setEenabledAll(boolean enabled) throws Exception {
        int i = 0;
        while (i < this.schemaObjectTableModel.tableContextList.size()) {
            XdtsSchemaObject tableContext = this.schemaObjectTableModel.tableContextList.get(i);
            tableContext.enabled = enabled;
            ++i;
        }
        this.tableView.refresh();
    }

    public List<XdtsSchemaObject> getSelecteSchemaObjectList() throws Exception {
        ArrayList<XdtsSchemaObject> schemaObjectList = new ArrayList<XdtsSchemaObject>();
        int i = 0;
        while (i < this.schemaObjectTableModel.tableContextList.size()) {
            XdtsSchemaObject schemaObject = this.schemaObjectTableModel.tableContextList.get(i);
            if (schemaObject.enabled) {
                schemaObjectList.add(schemaObject);
            }
            ++i;
        }
        return schemaObjectList;
    }

    class InnerTableView<S>
    extends FxTableView<S> {
    }
}

