/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.io.File;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsStagePane;
import jp.co.extreme.module.xdts.stub.XdtsWordStub;

public class XdtsLogicalNameImportPane
extends XdtsStagePane {
    protected Mode mode;
    protected int profileId;
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField filePathField = new FxTextField();
    FxButton fileBrowsButton = FxUtil.createBrowsButton(null);
    FileChooser fileChooser = new FileChooser();
    FxCheckBox checkBox = new FxCheckBox();
    FxButton executeButton = FxUtil.createExecuteButton();
    FxButton cancelButton = FxUtil.createCancelButton();

    public XdtsLogicalNameImportPane(Mode mode, int profileId) throws Exception {
        this.mode = mode;
        this.profileId = profileId;
        switch (mode) {
            case import_: {
                this.setComponant_common(BcWords.getInstance().file);
                this.setComponant_import();
                this.filePathField.setText(BcRuntimeUtil.getUserHomeDir().getPath());
                break;
            }
            case export: {
                this.setComponant_common(BcWords.getInstance().destination);
                File destFile = BcFileUtil.add_yyyyMMdd_HHmmssSSS("logical_name.csv", BcRuntimeUtil.getUserHomeDir());
                this.filePathField.setText(destFile.getPath());
            }
        }
        this.setCenter((Node)this.centerPane);
        this.underLineEnabled();
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setComponant_common(String fileText) throws Exception {
        this.executeButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.executeButton);
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
        this.filePathField.setPrefColumnCount(120);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(fileText), new Node[]{this.filePathField});
        this.fileBrowsButton.setOnAction(this.actionEventHandler);
        nodeUnit.addRightNodes(new Node[]{this.fileBrowsButton});
        this.centerPane.addNodeUnit(nodeUnit);
        this.fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(BcTableUtil.Extention.csv.name().toUpperCase(), new String[]{"*." + (Object)((Object)BcTableUtil.Extention.csv)})});
    }

    protected void setComponant_import() throws Exception {
        this.checkBox.setText(XdtsWords.getInstance().Delete_existing_data);
        FxNodeUnit nodeUnit = new FxNodeUnit(null, new Node[]{this.checkBox});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileBrowsButton) {
            FxUtil.initFileChooser(this.fileChooser, this.filePathField.getText());
            File file = this.fileChooser.showOpenDialog(this.getScene().getWindow());
            if (file != null) {
                this.filePathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.executeButton) {
            BcResult result = null;
            result = this.mode == Mode.import_ ? XdtsWordStub.getInstance().importCsv(this.profileId, this.filePathField.getText(), this.checkBox.isSelected()) : XdtsWordStub.getInstance().exportCsv(this.profileId, this.filePathField.getText());
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().error, 0);
            } else {
                String msg = BcMessageCreator.getInstance().createMessage(result.getInfoList());
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().information, 1);
            }
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    @Override
    protected Stage createStage() throws Exception {
        Stage stage = super.createStage();
        stage.setWidth(1040.0);
        stage.setHeight(240.0);
        stage.setResizable(false);
        if (this.mode == Mode.import_) {
            stage.getIcons().add((Object)FxImageHelper.getImage("import_64x64.png"));
        } else {
            stage.getIcons().add((Object)FxImageHelper.getImage("export_64x64.png"));
        }
        return stage;
    }

    public static enum Mode {
        import_(1),
        export(2);

        public final int id;

        private Mode(int id) {
            this.id = id;
        }
    }
}

