/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.dao;

import java.util.List;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xdts.model.XdtsTask;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XdtsTaskDAO
extends OrmAbstractDAO<XdtsTask> {
    private XdtsTaskDAO() {
        super(new XdtsTask[0]);
        this.setTableName("xdts_task");
        this.setViewName(String.valueOf(this.tableName) + "__v1");
    }

    public static XdtsTaskDAO getInstance() {
        return SingletonHolder.instance;
    }

    public List<XdtsTask> getTaskList(DtsSession dtsSession, Integer taskId, Integer timerId, Integer profileId) throws Exception {
        SqlWhereElement whereElement;
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(null));
        selectQuery.setFromClause(String.valueOf(this.viewName) + " AS " + this.tableName);
        if (taskId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("id = " + taskId);
            selectQuery.addWhereElement(whereElement);
        }
        if (timerId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("timer_id = " + timerId);
            selectQuery.addWhereElement(whereElement);
        }
        if (profileId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("profile_id = " + profileId);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.getOrderByList().add("timer_id");
        selectQuery.getOrderByList().add("execute_order");
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public List<XdtsTask> getTaskListByTimerId(DtsSession dtsSession, int timerId) throws Exception {
        return this.getTaskList(dtsSession, null, timerId, null);
    }

    public XdtsTask getTask(DtsSession dtsSession, int taskId) throws Exception {
        XdtsTask task = null;
        List<XdtsTask> taskList = this.getTaskList(dtsSession, taskId, null, null);
        if (taskList.size() > 0) {
            task = taskList.get(0);
        }
        return task;
    }

    /* synthetic */ XdtsTaskDAO(XdtsTaskDAO xdtsTaskDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XdtsTaskDAO instance = new XdtsTaskDAO(null);

        private SingletonHolder() {
        }
    }
}

