/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.util.EtcRsmdSupplement;
import jp.co.extreme.html.util.HtmlToPlain;
import jp.co.extreme.module.xdts.common.EtcSqlConditionUtil;
import jp.co.extreme.module.xdts.common.TemSqlParser;
import jp.co.extreme.module.xdts.common.XdtsSqlParserUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v001.XdtsSelectColumn;
import jp.co.extreme.module.xdts.model.v001.XdtsSelectContext;
import jp.co.extreme.module.xdts.model.v001.XdtsSelectElemet;
import net.sf.jsqlparser.Model;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;

public class XdtsSqlParser
extends BcLoggableObject {
    HtmlToPlain htmlToPlain = new HtmlToPlain();
    public EtcRsmdSupplement rsmdSupplement;
    public Map<String, String> map;

    public Select extractSelect(String sql) throws Exception {
        Statement statement2;
        this.getLogger().info("");
        this.getLogger().info("--------------------------------------------------");
        this.getLogger().info("#parseSelect");
        this.getLogger().info("sql=" + sql);
        this.getLogger().info("--------------------------------------------------");
        Statements statements = CCJSqlParserUtil.parseStatements((String)sql);
        List statementLsitList = statements.getStatements();
        this.getLogger().info("Statement\u6570=" + statementLsitList.size());
        for (Statement statement2 : statementLsitList) {
            this.getLogger().debug("statement=" + statement2);
        }
        if (statementLsitList.size() > 1) {
            String msg = "Statement\u304c\u8907\u6570\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002Statement\u6570=" + statementLsitList.size();
            throw new Exception(msg);
        }
        statement2 = (Statement)BcCollectionUtil.getFirst(statementLsitList);
        Select select = null;
        if (statement2 instanceof Select) {
            select = (Select)statement2;
        }
        return select;
    }

    public XdtsExtractionCondition createExtractionCondition(String query) throws Exception {
        this.getLogger().debug("query=" + query);
        TemSqlParser temSqlParser = new TemSqlParser();
        String queryWk = temSqlParser.parse(query);
        this.getLogger().debug("queryWk=" + queryWk);
        this.map = temSqlParser.map;
        Select select = this.extractSelect(queryWk);
        if (select == null) {
            return null;
        }
        XdtsExtractionCondition extractionCondition = new XdtsExtractionCondition();
        extractionCondition.selectContextList = new ArrayList<XdtsSelectContext>();
        extractionCondition.sqlOrign = query;
        this.rsmdSupplement = new EtcRsmdSupplement();
        this.parseSelect(select, extractionCondition);
        XdtsUtil.controlFidden(extractionCondition);
        return extractionCondition;
    }

    public void parseSelect(Select select, XdtsExtractionCondition extractionCondition) throws Exception {
        this.getLogger().debug("[Select]=" + select);
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("select", (Model)select));
        SelectBody selectBody = select.getSelectBody();
        this.parseSelectBody(selectBody, extractionCondition, null, null);
        List withItemList = select.getWithItemsList();
        if (withItemList != null) {
            for (WithItem withItem : withItemList) {
                this.getLogger().debug("#withItem=" + withItem);
            }
        }
    }

    public void parseSelectBody(SelectBody selectBody, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem) throws Exception {
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("selectBody", (Model)selectBody));
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            XdtsSelectContext xdtsSelectContext = this.createSelectContext(plainSelect, extractionCondition, parentSelectContext, parentElem);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            List selectBodyList = setOperationList.getSelects();
            this.getLogger().debug("selectBodyList.size()=" + selectBodyList.size());
            this.parse(setOperationList, extractionCondition, parentSelectContext, parentElem);
        } else {
            throw new Exception("selectBody class=" + selectBody.getClass().getName());
        }
    }

    public void parse(SetOperationList setOperationList, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem) throws Exception {
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("setOperationList", (Model)setOperationList));
        List selectBodyList = setOperationList.getSelects();
        for (SelectBody selectBody : selectBodyList) {
            this.parseSelectBody(selectBody, extractionCondition, parentSelectContext, parentElem);
        }
        List bracketList = setOperationList.getBrackets();
        this.getLogger().debug("bracketList=" + bracketList);
        this.getLogger().debug("setOperationList.getFetch()=" + setOperationList.getFetch());
        this.getLogger().debug("setOperationList.getLimit()=" + setOperationList.getLimit());
        this.getLogger().debug("setOperationList.getOffset()=" + setOperationList.getOffset());
        List operationList = setOperationList.getOperations();
        this.getLogger().debug("operationList=" + operationList);
        List orderByElement = setOperationList.getOrderByElements();
        this.getLogger().debug("orderByElement=" + orderByElement);
    }

    public void parseFrom(FromItem fromItem, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem, BcInteger hierarchy) throws Exception {
        if (hierarchy == null) {
            hierarchy = new BcInteger();
        }
        ++hierarchy.value;
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("fromItem-" + hierarchy, (Model)fromItem));
        if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            this.getLogger().debug("[subSelect]=" + subSelect);
            this.parseSubSelect(subSelect, extractionCondition, parentSelectContext, parentElem);
        } else if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            this.visitTabale(table);
        } else if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            this.parseSubJoin(subJoin, extractionCondition, parentSelectContext, parentElem, hierarchy);
        } else {
            throw new Exception(fromItem.getClass().getName());
        }
    }

    public void parseSubJoin(SubJoin subJoin, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem, BcInteger hierarchy) throws Exception {
        this.getLogger().debug("[SubJoin]=" + subJoin + " class=" + subJoin.getClass().getSimpleName());
        this.getLogger().debug("  subJoin.getLeft()=" + subJoin.getLeft());
        this.getLogger().debug("  subJoin.getPivot()=" + subJoin.getPivot() + " getUnPivot=" + subJoin.getUnPivot());
        this.getLogger().debug("  subJoin.getAlias()=" + subJoin.getAlias());
        this.parseFrom(subJoin.getLeft(), extractionCondition, parentSelectContext, parentElem, hierarchy);
        for (Join join : subJoin.getJoinList()) {
            this.parseJoin(join, extractionCondition, parentSelectContext, parentElem, hierarchy);
        }
    }

    public void parseJoin(Join join, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem, BcInteger hierarchy) throws Exception {
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("Join", join));
        this.parseFrom(join.getRightItem(), extractionCondition, parentSelectContext, parentElem, hierarchy);
    }

    public void parseSubSelect(SubSelect subSelect, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem) throws Exception {
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("subSelect", (Model)subSelect));
        this.getLogger().debug("subSelect.getAlias()=" + subSelect.getAlias());
        this.getLogger().debug("subSelect.getPivot()=" + subSelect.getPivot());
        this.getLogger().debug("subSelect.getUnPivot()=" + subSelect.getUnPivot());
        SelectBody selectBody = subSelect.getSelectBody();
        this.parseSelectBody(selectBody, extractionCondition, parentSelectContext, parentElem);
        List withItemsList = subSelect.getWithItemsList();
        this.getLogger().debug("withItemsList=" + withItemsList);
    }

    public void parseWhere(Expression where, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem) throws Exception {
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("where", (Model)where));
        if (where == null) {
            return;
        }
        if (where instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)where;
            Expression leftExpression = binaryExpression.getLeftExpression();
            this.parseWhere(leftExpression, extractionCondition, parentSelectContext, parentElem);
            Expression rightExpression = binaryExpression.getRightExpression();
            this.parseWhere(rightExpression, extractionCondition, parentSelectContext, parentElem);
        } else if (where instanceof Parenthesis) {
            Parenthesis parenthesis = (Parenthesis)where;
            this.parseWhere(parenthesis.getExpression(), extractionCondition, parentSelectContext, parentElem);
        } else if (where instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)where;
            this.parseSubSelect(subSelect, extractionCondition, parentSelectContext, parentElem);
        }
    }

    public XdtsSelectContext createSelectContext(PlainSelect plainSelect, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem) throws Exception {
        Expression expression;
        XdtsSelectContext selectContext = new XdtsSelectContext();
        selectContext.controlContextList = new ArrayList<XdtsControlContext>();
        selectContext.id = extractionCondition.selectContextList.size();
        selectContext.queryOrign = plainSelect.toString();
        extractionCondition.selectContextList.add(selectContext);
        String placeholder = XdtsSqlParserUtil.toPlaceholderSubSelect(selectContext.id);
        this.getLogger().debug("placeholder=" + placeholder);
        if (parentElem != null) {
            String str = XdtsSqlParserUtil.replaceFirst(parentElem.template, plainSelect.toString(), placeholder);
            this.getLogger().debug("str=" + str);
            parentElem.template = str;
        }
        selectContext.selectColumnList = new ArrayList<XdtsSelectColumn>();
        int i = 0;
        while (i < plainSelect.getSelectItems().size()) {
            SelectItem selectItem = (SelectItem)plainSelect.getSelectItems().get(i);
            this.getLogger().debug(XdtsSqlParserUtil.expressionLog("selectItem", selectItem));
            if (selectItem instanceof SelectExpressionItem) {
                Alias alias;
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                Expression expression2 = selectExpressionItem.getExpression();
                this.getLogger().debug(XdtsSqlParserUtil.expressionLog("selectExpressionItem", (Model)expression2));
                XdtsSelectColumn selectColumn = new XdtsSelectColumn();
                selectColumn.tableColumnName = new XdtsSelectElemet();
                selectColumn.tableColumnName.template = selectColumn.tableColumnName.orign = expression2.toString().trim();
                if (expression2 instanceof SubSelect) {
                    SubSelect subSelect = (SubSelect)expression2;
                    this.parseSubSelect(subSelect, extractionCondition, parentSelectContext, selectColumn.tableColumnName);
                }
                if ((alias = selectExpressionItem.getAlias()) != null) {
                    selectColumn.alias = alias.getName();
                    this.visitColumnAlias(selectExpressionItem, alias, i);
                }
                selectColumn.order = i + 1;
                selectContext.selectColumnList.add(selectColumn);
            } else if (selectItem instanceof AllColumns || selectItem instanceof AllTableColumns) {
                XdtsSelectColumn selectColumn = new XdtsSelectColumn();
                selectColumn.tableColumnName = new XdtsSelectElemet();
                selectColumn.tableColumnName.template = selectColumn.tableColumnName.orign = selectItem.toString().trim();
                selectColumn.order = i + 1;
                selectContext.selectColumnList.add(selectColumn);
            } else {
                throw new Exception(selectItem.toString());
            }
            ++i;
        }
        XdtsControlContext controlContext = XdtsSqlParserUtil.createSelectContext();
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createFromContext();
        FromItem fromItem = plainSelect.getFromItem();
        this.getLogger().debug("fromItem=" + fromItem);
        StringBuilder sb = new StringBuilder();
        sb.append(fromItem.toString());
        this.getLogger().debug("plainSelect.getJoins()=" + plainSelect.getJoins());
        List joinList = plainSelect.getJoins();
        if (!BcCollectionUtil.isEmpty(joinList)) {
            this.getLogger().debug("joinList.size()=" + joinList.size());
            int i2 = 0;
            while (i2 < joinList.size()) {
                Join join = (Join)joinList.get(i2);
                this.visitJoin(join);
                sb.append("\n " + join.toString());
                ++i2;
            }
        }
        selectContext.from = new XdtsSelectElemet();
        selectContext.from.template = selectContext.from.orign = sb.toString();
        selectContext.controlContextList.add(controlContext);
        this.parseFrom(fromItem, extractionCondition, selectContext, selectContext.from, null);
        Expression where = plainSelect.getWhere();
        selectContext.whereBase = new XdtsSelectElemet();
        selectContext.whereBase.template = selectContext.whereBase.orign = BcStringUtil.toString(where);
        controlContext = XdtsSqlParserUtil.createWhereContext();
        selectContext.controlContextList.add(controlContext);
        this.parseWhere(where, extractionCondition, parentSelectContext, selectContext.whereBase);
        GroupByElement groupByElement = plainSelect.getGroupBy();
        if (groupByElement == null) {
            selectContext.groupBy = null;
        } else {
            ExpressionList expressionList = groupByElement.getGroupByExpressionList();
            List expressionList2 = expressionList.getExpressions();
            this.getLogger().debug("expressionList2.size()=" + expressionList2.size());
            sb = new StringBuilder();
            int i3 = 0;
            while (i3 < expressionList2.size()) {
                expression = (Expression)expressionList2.get(i3);
                this.getLogger().debug(XdtsSqlParserUtil.expressionLog("groupByElement", (Model)expression));
                if (i3 > 0) {
                    sb.append(", ");
                }
                sb.append(expression.toString());
                ++i3;
            }
            selectContext.groupBy = sb.toString();
        }
        Expression havingExpression = plainSelect.getHaving();
        selectContext.having = new XdtsSelectElemet();
        selectContext.having.template = selectContext.having.orign = BcStringUtil.toString(havingExpression);
        this.parseWhere(havingExpression, extractionCondition, parentSelectContext, selectContext.having);
        controlContext = XdtsSqlParserUtil.createOrderByContext();
        selectContext.controlContextList.add(controlContext);
        List orderByElementList = plainSelect.getOrderByElements();
        selectContext.orderByList = new ArrayList<MmdIndex>();
        if (orderByElementList != null) {
            MmdIndex mmdIndex = new MmdIndex();
            int i4 = 0;
            while (i4 < orderByElementList.size()) {
                OrderByElement orderByElement = (OrderByElement)orderByElementList.get(i4);
                MmdIndexElement indexElement = new MmdIndexElement();
                indexElement.columnName = orderByElement.getExpression().toString();
                indexElement.isAscending = orderByElement.isAsc();
                mmdIndex.indexElementList.add(indexElement);
                ++i4;
            }
            selectContext.orderByList.add(mmdIndex);
        }
        if (selectContext.orderByList.size() > 0) {
            MmdIndex mmdIndex = selectContext.orderByList.get(0);
            controlContext.defaultValue = EtcSqlConditionUtil.createIndex(mmdIndex);
        }
        controlContext = XdtsSqlParserUtil.createRowLimitContext();
        Limit limit = plainSelect.getLimit();
        if (limit != null) {
            expression = limit.getRowCount();
            controlContext.defaultValue = expression.toString();
        }
        selectContext.controlContextList.add(controlContext);
        return selectContext;
    }

    protected void visitTabale(Table table) throws Exception {
        this.getLogger().debug("[Table]='" + table + "'  name=" + table.getName() + " alias='" + table.getAlias() + "'");
        Alias alias = table.getAlias();
        if (alias != null) {
            this.getLogger().debug("  alias=" + alias.getName());
            this.rsmdSupplement.tableAliasMap.put(table.getName().toLowerCase(), alias.getName().toLowerCase());
        }
    }

    protected void visitJoin(Join join) throws Exception {
        this.getLogger().debug("[Join]='" + join + " getASTNode=" + join.getASTNode() + " getJoinWindow=" + join.getJoinWindow());
        FromItem fromItem = join.getRightItem();
        this.getLogger().debug("  fromItem=" + fromItem + " getPivot=" + fromItem.getPivot() + " getUnPivot=" + fromItem.getUnPivot());
        Alias alias = fromItem.getAlias();
        if (alias != null) {
            String aName = this.getName(fromItem.toString());
            this.rsmdSupplement.tableAliasMap.put(aName.toLowerCase(), alias.getName().toLowerCase());
        }
    }

    protected void visitColumnAlias(SelectExpressionItem selectExpressionItem, Alias alias, int columnIndex) throws Exception {
        String columnAlias = this.removeQuotationMark(alias.getName());
        this.getLogger().debug("[ColumnAlias]='" + columnAlias + "' columnIndex=" + columnIndex);
        if (this.map != null && this.map.containsKey(columnAlias)) {
            String tmp = this.map.get(columnAlias);
            this.getLogger().debug("CONV:" + columnAlias + " -> " + tmp);
            columnAlias = tmp;
        }
        if (!(selectExpressionItem.getExpression() instanceof Column)) {
            this.getLogger().debug("selectExpressionItem.getExpression()=" + selectExpressionItem.getExpression().getClass());
            return;
        }
        String key = String.valueOf(columnAlias.toLowerCase()) + "-" + columnIndex;
        this.rsmdSupplement.columnAliasMap.put(key, selectExpressionItem.getExpression().toString());
    }

    protected String getName(String str) throws Exception {
        String[] array = str.split("\\s+");
        return array[0];
    }

    protected String removeQuotationMark(String str) throws Exception {
        if (BcStringUtil.isEmpty(str)) {
            return str;
        }
        if (str.charAt(0) == BcUnicode.quotationMark.char_) {
            if (str.length() == 1) {
                throw new Exception("str=" + str);
            }
            char lastChar = str.charAt(str.length() - 1);
            if (lastChar == BcUnicode.quotationMark.char_) {
                return str.substring(1, str.length() - 1);
            }
            throw new Exception("str=" + str);
        }
        return str;
    }
}

