/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.http.client.HtclContentLoader;
import jp.co.extreme.module.wbs1.wcb.Wbs1UrlCheckingTask;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.dao.XfilUriEntityDAO;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.scf.scheduler.ScfScheduler;
import jp.co.extreme.scf.scheduler.ScfTimerContext;
import jp.co.extreme.scf.scheduler.ScfTimerTask;

public class Wbs1UrlCash {
    protected List<XfilUriEntity> uriEntityList1 = new ArrayList<XfilUriEntity>();
    protected Map<String, BufferedImage> thumbnailMap = new HashMap<String, BufferedImage>();
    int maxCnt = 10000;
    InnerTimerTask timerTask = new InnerTimerTask();
    Wbs1UrlCheckingTask urlCheckingTask;
    boolean started = false;
    HtclContentLoader contentLoader = new HtclContentLoader();

    public Wbs1UrlCash() {
        this.urlCheckingTask = new Wbs1UrlCheckingTask(this);
    }

    public static Wbs1UrlCash getInstance() {
        return SingletonHolder.instance;
    }

    public void start() throws Exception {
        if (this.started) {
            return;
        }
        BcLogUtil.debug("UrlCash starting...");
        ScfTimerContext timerContext = new ScfTimerContext();
        timerContext.triggerId = 11;
        timerContext.intervalMillis = 1800000L;
        ScfScheduler.getInstance().addTimerTask(timerContext, this.timerTask);
        this.started = true;
    }

    public void taskProcess_L2(DtsSession dtsSession) throws Exception {
        BcLogUtil.debug("taskProcess2..");
        XfilUriEntityDAO dao = XfilUriEntityDAO.getInstance(XfilConstants.TableName.xfil_entity.name());
        List uriEntityList2 = dao.getListByLimit(dtsSession, 1000);
        BcLogUtil.debug("uriEntityList2.size()=" + uriEntityList2.size());
        ArrayList<XfilUriEntity> uriEntityList3 = new ArrayList<XfilUriEntity>();
        int i = 0;
        while (i < uriEntityList2.size()) {
            XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList2.get(i);
            this.taskProcess_L3_1(uriEntity, uriEntityList3);
            ++i;
        }
        if (uriEntityList3.size() > 0) {
            dao.putEntityCollection(dtsSession, uriEntityList3);
        }
    }

    protected void taskProcess_L3_1(XfilUriEntity uriEntity, List<XfilUriEntity> uriEntityList) throws Exception {
        URL url = XfilUtil.toUrl(uriEntity);
        try {
            ByteArrayOutputStream baos = this.contentLoader.getContent(url);
            byte[] bytes = baos.toByteArray();
            if ((long)bytes.length != uriEntity.size) {
                BcLogUtil.debug("\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u30b5\u30a4\u30ba\u304c\u7570\u306a\u308b\u306e\u3067\u7121\u8996:url=" + url + " uriEntity.size=" + uriEntity.size + " bytes.length=" + bytes.length);
                uriEntity.short01 = -1;
                uriEntityList.add(uriEntity);
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            BufferedImage bufferedImage = AwtImageUtil.loadImage((InputStream)bais, uriEntity.extention);
            bufferedImage = AwtImageUtil.resizeImage(bufferedImage, 238.0, -1.0);
            if (Wbs1UrlCash.getInstance().uriEntityList1.size() < Wbs1UrlCash.getInstance().maxCnt) {
                Wbs1UrlCash.getInstance().uriEntityList1.add(uriEntity);
                BcLogUtil.debug("taskProcess_L3_1:uriEntity.id=" + uriEntity.id);
                Wbs1UrlCash.getInstance().thumbnailMap.put(Long.toString(uriEntity.id), bufferedImage);
            } else {
                BcLogUtil.debug("URL\u30ad\u30e5\u30fc\u304c\u6700\u5927\u5024\u3092\u8d85\u904e\u3057\u3066\u3044\u308b\u306e\u3067\u51e6\u7406\u3057\u307e\u305b\u3093\u3002");
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            BcLogUtil.debug("ERR:url=" + url);
            uriEntity.short01 = -1;
            uriEntityList.add(uriEntity);
        }
    }

    public List<XfilUriEntity> poll(int reqCnt) throws Exception {
        if (this.uriEntityList1.size() <= 0) {
            this.urlCheckingTask.taskProcess();
        }
        ArrayList<XfilUriEntity> uriEntityList2 = new ArrayList<XfilUriEntity>();
        if (this.uriEntityList1.size() <= reqCnt) {
            uriEntityList2.addAll(this.uriEntityList1);
            return uriEntityList2;
        }
        ArrayList<String> urlList = new ArrayList<String>();
        Random random = new Random();
        while (true) {
            int index;
            XfilUriEntity uriEntity;
            URL url;
            if (urlList.contains((url = XfilUtil.toUrl(uriEntity = this.uriEntityList1.get(index = random.nextInt(this.uriEntityList1.size())))).toString())) {
                continue;
            }
            urlList.add(url.toString());
            uriEntityList2.add(uriEntity);
            if (uriEntityList2.size() >= reqCnt) break;
        }
        return uriEntityList2;
    }

    public class InnerTimerTask
    extends ScfTimerTask {
        @Override
        protected void run2() throws Exception {
            Wbs1UrlCash.this.urlCheckingTask.taskProcess();
        }
    }

    private static final class SingletonHolder {
        private static final Wbs1UrlCash instance = new Wbs1UrlCash();

        private SingletonHolder() {
        }
    }
}

