/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.util.EtcSqlUtil;
import jp.co.extreme.etc.model.EtcQueryCondition;
import jp.co.extreme.module.wbs1.dao.Wbs1RecruitmentDAO;
import jp.co.extreme.module.wbs1.dao.Wbs1ShopDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;

public class Wbs1ShopDataHelper {
    Map<String, List<String>> listMap = new HashMap<String, List<String>>();

    private Wbs1ShopDataHelper() {
    }

    public static Wbs1ShopDataHelper getInstance() {
        return SingletonHolder.instance;
    }

    public BcTableModel groupByQueryTable(DtsSession dtsSession, EtcQueryCondition queryCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectQuery selectQuery = SqlUtil.createGroupBySql(queryCondition.tableName, queryCondition.columNameList, queryCondition.ascending, queryCondition.rowLimit);
        String alias = "a";
        String query = sqlContext.buildSelectQuery(selectQuery);
        BcTableModel tableModel = EtcSqlUtil.createTableModel(dtsSession, query, null);
        return tableModel;
    }

    public List<String> groupByQueryList(DtsSession dtsSession, EtcQueryCondition queryCondition) throws Exception {
        BcTableModel tableModel = this.groupByQueryTable(dtsSession, queryCondition);
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            Object value = tableModel.getValueAt(i, 0);
            valueList.add(BcStringUtil.toString(value));
            ++i;
        }
        return valueList;
    }

    public List<String> groupByQueryList(DtsSession dtsSession, String tableName, String columnName) throws Exception {
        EtcQueryCondition queryCondition = new EtcQueryCondition();
        queryCondition.tableName = tableName;
        queryCondition.columNameList = new ArrayList<String>();
        queryCondition.columNameList.add(columnName);
        List<String> valueList = this.groupByQueryList(dtsSession, queryCondition);
        return valueList;
    }

    public List<String> geList(DtsSession dtsSession, String tableName, String columnName) throws Exception {
        String tableColumnName = MmdUtil.createTableColumnName(tableName, columnName);
        List<String> valueList = this.listMap.get(tableColumnName);
        if (valueList != null) {
            return valueList;
        }
        valueList = this.groupByQueryList(dtsSession, tableName, columnName);
        this.listMap.put(tableColumnName, valueList);
        return valueList;
    }

    public List<String> getAreaList(DtsSession dtsSession) throws Exception {
        return this.geList(dtsSession, Wbs1ShopDAO.getInstance().getTableName(), "area");
    }

    public List<String> getBusinessTypeList(DtsSession dtsSession) throws Exception {
        return this.geList(dtsSession, Wbs1ShopDAO.getInstance().getTableName(), "business_type");
    }

    public List<String> getOccupationList(DtsSession dtsSession) throws Exception {
        return this.geList(dtsSession, Wbs1RecruitmentDAO.getInstance().getTableName(), "occupation");
    }

    /* synthetic */ Wbs1ShopDataHelper(Wbs1ShopDataHelper wbs1ShopDataHelper) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1ShopDataHelper instance = new Wbs1ShopDataHelper(null);

        private SingletonHolder() {
        }
    }
}

