/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.dao;

import java.util.List;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbs1.model.Wbs1PersonalIdentification;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class Wbs1PersonalIdentificationDAO
extends OrmAbstractDAO<Wbs1PersonalIdentification> {
    private Wbs1PersonalIdentificationDAO() {
        super(new Wbs1PersonalIdentification[0]);
        this.setTableName("wbs1_personal_identification");
    }

    public static Wbs1PersonalIdentificationDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, WbsTempCondition tempCondition) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (tempCondition.personId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id =" + tempCondition.personId);
            selectQuery.addWhereElement(whereElement);
        }
        if (tempCondition.judgementStatusId == BcConstants.Existence.FALSE.value) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "judgement_datetime Is null");
            selectQuery.addWhereElement(whereElement);
        } else if (tempCondition.judgementStatusId == BcConstants.Existence.TRUE.value) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "judgement_datetime Is Not null");
            selectQuery.addWhereElement(whereElement);
        }
        StringBuilder fromClause = new StringBuilder();
        fromClause.append(String.valueOf(this.getTableName()) + " AS " + alias);
        selectQuery.setFromClause(fromClause.toString());
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, WbsTempCondition tempCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, tempCondition);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getByPersonId(DtsSession dtsSession, WbsTempCondition tempCondition) throws Exception {
        if (tempCondition.personId <= 0L) {
            return null;
        }
        List<T> entityList = this.getList(dtsSession, Mode.personId, tempCondition);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1PersonalIdentificationDAO(Wbs1PersonalIdentificationDAO wbs1PersonalIdentificationDAO) {
        this();
    }

    public static enum Mode {
        personId("person_id");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final Wbs1PersonalIdentificationDAO instance = new Wbs1PersonalIdentificationDAO(null);

        private SingletonHolder() {
        }
    }
}

