/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.scrp.fx;

import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxTabPane;
import jp.co.extreme.fx.control.FxTextArea;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.scrp.fx.ScrpScriptDesktop;
import jp.co.extreme.module.scrp.model.ScrpScript;
import jp.co.extreme.scf4.fx.HfxConsolePane;
import jp.co.extreme.scf4.fx.HfxElapsedTimePanel;
import jp.co.extreme.task.TskTaskEvent;

class ScrpScriptPane2
extends FxBorderPane
implements BcEventHandler<TskTaskEvent> {
    BorderPane borderPane1 = new BorderPane();
    HBox controlHBox = new HBox();
    HBox bottomHBox = new HBox();
    HfxElapsedTimePanel elapsedTimePanel = new HfxElapsedTimePanel();
    Label statusLabel = new Label();
    SplitPane splitPane = new SplitPane();
    FxTabPane tabPane = new FxTabPane();
    FxTextArea textArea = new FxTextArea();
    HfxConsolePane consolePane1 = new HfxConsolePane();
    HfxConsolePane consolePane2 = new HfxConsolePane();
    Button executeButton;
    ScrpScriptDesktop parent;
    ScrpScript script;

    public ScrpScriptPane2() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.executeButton = FxUtil.createExecuteButton();
        this.executeButton.setOnAction(this.actionEventHandler);
        this.controlHBox.setAlignment(Pos.CENTER_LEFT);
        this.controlHBox.getChildren().addAll((Object[])new Node[]{this.executeButton});
        this.borderPane1.setTop((Node)this.controlHBox);
        this.bottomHBox.setAlignment(Pos.CENTER_LEFT);
        this.bottomHBox.getChildren().addAll((Object[])new Node[]{this.elapsedTimePanel, this.statusLabel});
        this.borderPane1.setBottom((Node)this.bottomHBox);
        this.statusLabel.setPrefWidth(240.0);
        Tab tab = new Tab();
        tab.setText(BcWords.getInstance().console);
        tab.setGraphic((Node)FxImageHelper.createImageView_icon("console_64x64.png"));
        tab.setContent((Node)this.consolePane1);
        tab.setClosable(false);
        this.tabPane.getTabs().add((Object)tab);
        tab = new Tab();
        tab.setText(BcWords.getInstance().log);
        tab.setGraphic((Node)FxImageHelper.createImageView_icon("console_64x64.png"));
        tab.setContent((Node)this.consolePane2);
        tab.setClosable(false);
        this.tabPane.getTabs().add((Object)tab);
        this.splitPane.setOrientation(Orientation.VERTICAL);
        this.splitPane.getItems().addAll((Object[])new Node[]{this.textArea, this.tabPane});
        this.splitPane.setDividerPositions(new double[]{0.7f, 0.3f});
        this.borderPane1.setCenter((Node)this.splitPane);
        this.setCenter((Node)this.borderPane1);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setData(ScrpScript script) throws Exception {
        this.script = script;
        this.textArea.setText(script.script);
        this.consolePane1.textArea.setText(script.note);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.executeButton) {
            this.executeButton.setDisable(true);
            this.elapsedTimePanel.start();
            this.parent.parent.execute();
        }
    }

    @Override
    public void handle(final TskTaskEvent event) throws Exception {
        if (event.getEventType() == TskTaskEvent.EventType.Started) {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    ScrpScriptPane2.this.statusLabel.setText(event.getEventType().toString());
                }
            });
        } else if (event.getEventType() == TskTaskEvent.EventType.Finished) {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    ScrpScriptPane2.this.elapsedTimePanel.stop();
                    ScrpScriptPane2.this.statusLabel.setText(event.getEventType().toString());
                    ScrpScriptPane2.this.executeButton.setDisable(false);
                }
            });
        } else if (event.getEventType() == TskTaskEvent.EventType.Log) {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    ScrpScriptPane2.this.consolePane2.addLine(BcLogUtil.convertMessage(event.getUserObject()));
                }
            });
        }
    }
}

