/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.advm.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.http.client.HtclContentLoader;
import jp.co.extreme.module.advm.client.AdvmAdvertisementTask;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdvmAdvertisementManager {
    protected Node advertisementNode;
    protected Document advertisementDom;
    protected AdvmAdvertisementTask advertisementTask;
    BcMonitor parentMonitor;

    public void setAdvertisementTask(AdvmAdvertisementTask advertisementTask) throws Exception {
        this.advertisementTask = advertisementTask;
    }

    public void checkBootConfig(BcMonitor parentMonitor) throws Exception {
        this.parentMonitor = parentMonitor;
        Document bootConfig = AfbApplication.getInstance().getBootConfig();
        this.advertisementNode = BcXmlUtil.getNode(bootConfig, "advertisement");
        if (this.advertisementNode != null) {
            this.loadAdvertisementXml();
        }
        if (this.advertisementDom == null) {
            return;
        }
        if (parentMonitor != null) {
            parentMonitor.lock();
        }
        this.parseDom();
    }

    protected void loadAdvertisementXml() throws Exception {
        Node urlListNode = BcXmlUtil.getNode(this.advertisementNode, "urlList");
        if (urlListNode == null) {
            return;
        }
        List<Node> urlNodeList = BcXmlUtil.getNodeList(urlListNode, "url");
        HtclContentLoader contentLoader = new HtclContentLoader();
        int i = 0;
        while (i < urlNodeList.size()) {
            Node urlNode = urlNodeList.get(i);
            try {
                URL url = new URL(BcXmlUtil.getTextValue(urlNode));
                ByteArrayOutputStream baos = contentLoader.getContent(url);
                if (baos != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    this.advertisementDom = BcXmlUtil.createDocument(bais);
                    break;
                }
            }
            catch (ConnectException ex) {
                BcLogUtil.warning(ex);
            }
            catch (UnknownHostException ex) {
                BcLogUtil.warning(ex);
            }
            catch (SocketTimeoutException ex) {
                BcLogUtil.warning(ex);
            }
            catch (Exception ex) {
                throw ex;
            }
            ++i;
        }
    }

    protected void parseDom() throws Exception {
        int version = Integer.parseInt(BcXmlUtil.getAttribute(this.advertisementDom.getDocumentElement(), "version"));
        if (version != 1) {
            throw new Exception("Not supported version=" + version);
        }
        this.parseDom_L2();
    }

    protected void parseDom_L2() throws Exception {
        NodeList nodeList = this.advertisementDom.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (BcStringUtil.equals(node.getNodeName(), "item")) {
                this.parseDom_L3(node);
            }
            ++i;
        }
    }

    protected void parseDom_L3(Node itemNode) throws Exception {
        NodeList nodeList = itemNode.getChildNodes();
        BcLogUtil.debug("parseDom_L3:nodeList.getLength()=" + nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (BcStringUtil.equals(node.getNodeName(), "web")) {
                this.advertisementTask.setWebNode(node);
                ExecutorService executorService = Executors.newCachedThreadPool();
                Future future = executorService.submit(this.advertisementTask);
                break;
            }
            ++i;
        }
    }
}

