/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.lib.google;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.GeocodingApiRequest;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;
import jp.co.extreme.base.log.BcLogger;

public final class ExtGoogleUtil {
    public static String urlFormat = "https://maps.googleapis.com/maps/api/geocode/json?latlng=%s,%s&location_type=ROOFTOP&result_type=street_address&key=%s";
    public static final String apiKey = "AIzaSyC6D3ymIeu4ndDvaYBqkdX52eFuJR9towY";

    private ExtGoogleUtil() {
    }

    public static GeocodingResult reverceGeocoding(double latitude, double longitude, String apiKey, BcLogger logger) throws Exception {
        logger.info("\u7def\u5ea6=" + latitude + " \u7d4c\u5ea6=" + longitude);
        LatLng latlng = new LatLng(latitude, longitude);
        GeoApiContext apiContext = new GeoApiContext.Builder().apiKey(apiKey).build();
        GeocodingApiRequest apiRequest = (GeocodingApiRequest)GeocodingApi.reverseGeocode((GeoApiContext)apiContext, (LatLng)latlng).language("ja");
        try {
            GeocodingResult[] geocodingResults = (GeocodingResult[])apiRequest.await();
            GeocodingResult geocodingResult = geocodingResults[0];
            return geocodingResult;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            apiContext.shutdown();
        }
    }

    public static String toAddress(GeocodingResult geocodingResult) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String address = gson.toJson((Object)geocodingResult.formattedAddress);
        return address;
    }

    public static String createGeocodingUrl(double latitude, double longitude, String apiKey) {
        String url = String.format(urlFormat, latitude, longitude, apiKey);
        return url;
    }
}

