/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.extension;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.etc.model.EtcInputText;
import jp.co.extreme.fx.control.FxRadioButton;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxFontUtil;
import jp.co.extreme.fx.util.FxUtil;

public class FxxRadioButtonControl
extends FxBorderPane
implements EtcInputText {
    Pane centerPane;
    public ToggleGroup toggleGroup = new ToggleGroup();
    List<RadioButton> radioButtonList = new ArrayList<RadioButton>();
    FxRadioButton unspecifiedRadioButton = new FxRadioButton();
    double spacing = 8.0;

    public FxxRadioButtonControl(boolean isHBox) throws Exception {
        if (isHBox) {
            HBox hBox = new HBox();
            hBox.setSpacing(this.spacing);
            hBox.setAlignment(Pos.CENTER_LEFT);
            this.centerPane = hBox;
        } else {
            VBox vBox = new VBox();
            vBox.setSpacing(this.spacing);
            vBox.setAlignment(Pos.CENTER_LEFT);
            this.centerPane = vBox;
        }
        this.setCenter((Node)this.centerPane);
    }

    @Override
    public String getInputText() throws Exception {
        int i = 0;
        while (i < this.radioButtonList.size()) {
            RadioButton radioButton = this.radioButtonList.get(i);
            if (this.toggleGroup.getSelectedToggle() == radioButton) {
                return (String)radioButton.getUserData();
            }
            ++i;
        }
        return (String)this.unspecifiedRadioButton.getUserData();
    }

    @Override
    public void setInputText(String strValue) throws Exception {
        int i = 0;
        while (i < this.radioButtonList.size()) {
            RadioButton radioButton = this.radioButtonList.get(i);
            if (radioButton.getUserData().equals(strValue)) {
                radioButton.setSelected(true);
                return;
            }
            ++i;
        }
        this.unspecifiedRadioButton.setSelected(true);
    }

    public void setData(Collection<? extends Map.Entry<String, String>> mapEntryCollection) throws Exception {
        this.toggleGroup.getToggles().clear();
        this.centerPane.getChildren().clear();
        this.radioButtonList.clear();
        for (Map.Entry<String, String> entry : mapEntryCollection) {
            FxRadioButton radioButton = new FxRadioButton(entry.getValue());
            radioButton.setUserData(entry.getKey());
            FxUtil.setPrefSize_RadioButton(radioButton);
            radioButton.setToggleGroup(this.toggleGroup);
            this.radioButtonList.add(radioButton);
            this.centerPane.getChildren().add((Object)radioButton);
        }
        this.setUnspecified(false, null, null);
    }

    public void setData(String[] keys, String[] texts) throws Exception {
        ArrayList<AbstractMap.SimpleEntry<String, String>> mapEntryList = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        int i = 0;
        while (i < keys.length) {
            AbstractMap.SimpleEntry<String, String> mapEntry = new AbstractMap.SimpleEntry<String, String>(keys[i], texts[i]);
            mapEntryList.add(mapEntry);
            ++i;
        }
        this.setData(mapEntryList);
    }

    public void setData2(Collection<String> keyCollection) throws Exception {
        ArrayList<AbstractMap.SimpleEntry<String, String>> mapEntryList = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        for (String key : keyCollection) {
            AbstractMap.SimpleEntry<String, String> mapEntry = new AbstractMap.SimpleEntry<String, String>(key, key);
            mapEntryList.add(mapEntry);
        }
        this.setData(mapEntryList);
    }

    public void setUnspecified(boolean enabled, String key, String labelText) throws Exception {
        if (enabled) {
            this.unspecifiedRadioButton.setToggleGroup(this.toggleGroup);
            this.unspecifiedRadioButton.setSelected(true);
            this.centerPane.getChildren().add((Object)this.unspecifiedRadioButton);
        } else {
            this.unspecifiedRadioButton.setToggleGroup(null);
            this.centerPane.getChildren().remove((Object)this.unspecifiedRadioButton);
        }
        this.unspecifiedRadioButton.setUserData(key);
        if (BcStringUtil.isEmpty(labelText)) {
            this.unspecifiedRadioButton.setText(BcWords.getInstance().notSpecified);
        } else {
            this.unspecifiedRadioButton.setText(labelText);
        }
        FxUtil.setPrefSize_RadioButton(this.unspecifiedRadioButton);
        Dimension2D dim2d = this.compluteSize();
        FxUtil.setPrefSize((Region)this, dim2d);
    }

    public void setUnspecified(boolean enabled) throws Exception {
        this.setUnspecified(enabled, null, null);
    }

    public Dimension2D compluteSize() throws Exception {
        Dimension2D dim2d = FxUtil.getTextFieldSize(FxFontUtil.getDefaultFont(), 1);
        double width = 0.0;
        ObservableList toggleList = this.toggleGroup.getToggles();
        int i = 0;
        while (i < toggleList.size()) {
            Toggle toggle = (Toggle)toggleList.get(i);
            if (toggle instanceof Control) {
                Control control = (Control)toggle;
                width += control.getPrefWidth();
                if (i > 0) {
                    width += this.spacing;
                }
            }
            ++i;
        }
        dim2d = new Dimension2D(width, dim2d.getHeight());
        return dim2d;
    }

    public void setValue(FxxRadioButtonControl radioButtonControl) throws Exception {
        this.setInputText(radioButtonControl.getInputText());
    }
}

