/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.doc.barcode.renderer;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import jp.co.extreme.awt.AwtImageObserver;
import jp.co.extreme.doc.barcode.renderer.DcfAbstractBarcodeRenderer;

public class DcfQrCodeRenderer
extends DcfAbstractBarcodeRenderer {
    private int width = 200;
    private int height = 200;
    private QRCodeWriter writer = new QRCodeWriter();
    private BufferedImage bufferedImage;
    private String barcodeValue;
    private AwtImageObserver imageObserver = new AwtImageObserver();

    @Override
    public double[] getSize(String value) throws Exception {
        this.setBarcodeValue(value);
        double[] dim = new double[]{this.bufferedImage.getWidth(), this.bufferedImage.getHeight()};
        return dim;
    }

    @Override
    public void drawBarcode(Graphics2D g2d, double bx, double by, String barcodeValue) throws Exception {
        this.setBarcodeValue(barcodeValue);
        g2d.drawImage(this.bufferedImage, (int)bx, (int)by, this.bufferedImage.getWidth(), this.bufferedImage.getHeight(), this.imageObserver);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getBarcodeValue() {
        return this.barcodeValue;
    }

    public void setBarcodeValue(String barcodeValue) throws Exception {
        this.barcodeValue = barcodeValue;
        HashMap<EncodeHintType, Charset> hintMap = new HashMap<EncodeHintType, Charset>();
        hintMap.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8);
        hintMap.put(EncodeHintType.ERROR_CORRECTION, (Charset)ErrorCorrectionLevel.M);
        BitMatrix bitMatrix = this.writer.encode(barcodeValue, BarcodeFormat.QR_CODE, this.width, this.height, hintMap);
        this.bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);
    }

    public BufferedImage getImage() {
        return this.bufferedImage;
    }
}

