/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.util.BcEscapeSequence;
import org.apache.commons.lang3.ArrayUtils;

public final class BcConsoleHelper {
    private PrintStream os = System.out;
    private InputStream is = System.in;
    public String prompt = ">";
    public String lineSeparator;
    public final String windows_cmd = "cmd";

    public BcConsoleHelper() {
        this.lineSeparator = BcUnicode.LF.string;
        this.windows_cmd = "cmd";
    }

    public void disp(String str) throws Exception {
        this.os.print(str);
    }

    public PrintStream gePrintStream() {
        return this.os;
    }

    public String input(String msg) throws Exception {
        if (!BcStringUtil.isEmpty(msg)) {
            this.disp(msg);
            this.disp(this.lineSeparator);
        }
        this.disp(this.prompt);
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        while (true) {
            int intValue = this.is.read();
            char aChar = (char)intValue;
            if (intValue == -1) break;
            if (aChar == '\r') continue;
            if (aChar == '\n') break;
            byteList.add((byte)intValue);
        }
        Byte[] byteObjects = byteList.toArray(new Byte[byteList.size()]);
        byte[] bytes = ArrayUtils.toPrimitive(byteObjects);
        String str = new String(bytes, BcConstants.charset);
        return str;
    }

    public void screenClear() throws Exception {
        if (BcRuntimeUtil.getOsType() == BcRuntimeUtil.OsType.Windows) {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd", "/c", "cls");
            processBuilder.inheritIO().start().waitFor();
        } else {
            this.os.print(BcEscapeSequence.SCREEN_CLEAR);
            this.os.print(BcEscapeSequence.CURSOR_START);
        }
    }

    public void pause(String msg) throws Exception {
        this.disp(msg);
        int c = this.is.read();
    }

    public boolean ask_yn(String msg) throws Exception {
        String input = this.input(msg);
        char aChar = '\u0000';
        if (input.length() == 0) {
            aChar = input.charAt(0);
        }
        boolean bool = false;
        if (aChar == 'y' || aChar == 'Y') {
            bool = true;
        }
        return bool;
    }
}

