/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import jp.co.extreme.base.core.BcConstants;

public final class BcCipherUtil {
    private BcCipherUtil() {
    }

    public static byte[] encrypt(String key, String text) throws Exception {
        SecretKeySpec scretKeySpec = new SecretKeySpec(key.getBytes(), Algorithm.Blowfish.value);
        Cipher cipher = Cipher.getInstance(Algorithm.Blowfish.value);
        cipher.init(1, scretKeySpec);
        byte[] bytes = text.getBytes(BcConstants.charset);
        return cipher.doFinal(bytes);
    }

    public static String encryptText(String key, String text) throws Exception {
        byte[] bytes = BcCipherUtil.encrypt(key, text);
        byte[] encryptBytes64 = Base64.getEncoder().encode(bytes);
        return new String(encryptBytes64, BcConstants.charset);
    }

    public static String decrypt(String key, byte[] bytes) throws Exception {
        SecretKeySpec scretKeySpec = new SecretKeySpec(key.getBytes(), Algorithm.Blowfish.value);
        Cipher cipher = Cipher.getInstance(Algorithm.Blowfish.value);
        cipher.init(2, scretKeySpec);
        byte[] bytes2 = cipher.doFinal(bytes);
        return new String(bytes2, BcConstants.charset);
    }

    public static String decrypt(String key, String encryptStr) throws Exception {
        byte[] bytes = Base64.getDecoder().decode(encryptStr);
        return BcCipherUtil.decrypt(key, bytes);
    }

    public static enum Algorithm {
        Blowfish("Blowfish");

        public final String value;

        private Algorithm(String value) {
            this.value = value;
        }
    }
}

