/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.jar.Manifest;
import jp.co.extreme.base.core.BcJavaConstants;
import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.runtime.JarFileVisitor;

public final class BcRuntimeUtil {
    public static final String ATTRIBUTE_MainClass = "Main-Class";
    private static int javaMajorVersion;
    private static OsType osType;
    public static final String lineSeparator;
    public static final String fileSeparator;

    static {
        lineSeparator = System.getProperty(BcJavaConstants.SysKey.line_separator.value);
        fileSeparator = System.getProperty(BcJavaConstants.SysKey.file_separator.value);
    }

    private BcRuntimeUtil() {
    }

    public static int getProcessId() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String name = runtimeMXBean.getName();
        int pid = -1;
        if (name.matches("\\d+@.*")) {
            pid = Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        return pid;
    }

    public static File getUserDir() {
        File dir = new File(System.getProperty(BcJavaConstants.SysKey.user_dir.value));
        return dir;
    }

    public static File getUserHomeDir() {
        File dir = new File(System.getProperty(BcJavaConstants.SysKey.user_home.value));
        return dir;
    }

    public static String getJavaVersion() {
        return System.getProperties().getProperty(BcJavaConstants.SysKey.java_version.value);
    }

    public static int getJavaMajorVersion() {
        if (javaMajorVersion <= 0) {
            String javaVersion = BcRuntimeUtil.getJavaVersion();
            int pos = javaVersion.indexOf(".");
            String str = javaVersion.substring(0, pos);
            javaMajorVersion = Integer.parseInt(str);
        }
        return javaMajorVersion;
    }

    public static ClassLoader addClassPath(ClassLoader classLoader, Collection<File> fileCollection) throws Exception {
        if (BcRuntimeUtil.getJavaMajorVersion() >= 9) {
            Method method = classLoader.getClass().getDeclaredMethod("appendToClassPathForInstrumentation", String.class);
            method.setAccessible(true);
            for (File file : fileCollection) {
                method.invoke((Object)classLoader, file.getPath());
            }
            return classLoader;
        }
        URLClassLoader urlClassLoader = null;
        if (classLoader instanceof URLClassLoader) {
            urlClassLoader = (URLClassLoader)classLoader;
        } else {
            URL[] urlsDummy = new URL[]{};
            urlClassLoader = URLClassLoader.newInstance(urlsDummy, classLoader);
        }
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        for (File file : fileCollection) {
            URL url = file.toURI().toURL();
            method.invoke((Object)urlClassLoader, url);
        }
        return urlClassLoader;
    }

    public static ClassLoader addClassPath(ClassLoader classLoader, File dir) throws Exception {
        List<File> fileList = BcRuntimeUtil.createJarFileList(dir);
        return BcRuntimeUtil.addClassPath(classLoader, fileList);
    }

    public static URL getResourceUrl(Class clazz) throws Exception {
        URL resourceUrl = clazz.getResource(BcLangUtil.toClassFileName(clazz));
        return resourceUrl;
    }

    public static URL getJarFileUrl(URL url) throws Exception {
        URLConnection urlConnection = url.openConnection();
        URL jarFileUrl = null;
        if (urlConnection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
            jarFileUrl = jarURLConnection.getJarFileURL();
        }
        return jarFileUrl;
    }

    public static URL getJarFileUrl(Class clazz) throws Exception {
        URL jarUrl = BcRuntimeUtil.getResourceUrl(clazz);
        if (jarUrl == null) {
            return null;
        }
        return BcRuntimeUtil.getJarFileUrl(jarUrl);
    }

    public static URL getStartJarUrl() throws Exception {
        String sunJavaCommand = System.getProperty(BcJavaConstants.SysKey.sun_java_command.value);
        File file = new File(sunJavaCommand);
        URL url = null;
        if (file.exists()) {
            url = file.toURI().toURL();
        }
        return url;
    }

    public static List<File> createJarFileList(File dir) throws Exception {
        EnumSet<FileVisitOption> fileVisitOptionSet = EnumSet.allOf(FileVisitOption.class);
        Path path = Paths.get(dir.getPath(), new String[0]);
        JarFileVisitor fileVisitor = new JarFileVisitor();
        fileVisitor.fileList = new ArrayList<File>();
        Files.walkFileTree(path, fileVisitOptionSet, Integer.MAX_VALUE, fileVisitor);
        return fileVisitor.fileList;
    }

    public static List<URL> createJarUrlList(File dir) throws Exception {
        List<File> fileList = BcRuntimeUtil.createJarFileList(dir);
        List<URL> urlList = BcFileUtil.toUrlList(fileList);
        return urlList;
    }

    public static Class getMainClass() throws Exception {
        String sunJavaCommand = System.getProperty(BcJavaConstants.SysKey.sun_java_command.value);
        String[] texts = sunJavaCommand.split("[\\s]+");
        Class<?> clazz = Class.forName(texts[0]);
        return clazz;
    }

    public static String getMainClassValue(Class clazz) throws Exception {
        Manifest manifest = BcRuntimeUtil.getManifest(clazz);
        if (manifest == null) {
            return null;
        }
        return manifest.getMainAttributes().getValue(ATTRIBUTE_MainClass);
    }

    public static Manifest getManifest(Class clazz) throws Exception {
        URL resourceUrl = BcRuntimeUtil.getResourceUrl(clazz);
        String s = resourceUrl.toExternalForm();
        String jar = s.substring(0, s.lastIndexOf(clazz.getPackage().getName().replace('.', '/')));
        URL manifestUrl = new URL(String.valueOf(jar) + "META-INF/MANIFEST.MF");
        Manifest manifest = null;
        try {
            InputStream inputStream = manifestUrl.openStream();
            manifest = new Manifest(inputStream);
        }
        catch (IOException ex) {
            return null;
        }
        return manifest;
    }

    public static boolean isJava_1_8() {
        String javaVersion = BcRuntimeUtil.getJavaVersion();
        return javaVersion.startsWith("1.8");
    }

    public static OsType getOsType() {
        if (osType != null) {
            return osType;
        }
        String osName = System.getProperty(BcJavaConstants.SysKey.os_name.value).toLowerCase();
        OsType[] osTypeArray = OsType.values();
        int n = osTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OsType osTypeWk = osTypeArray[n2];
            if (osName.indexOf(osTypeWk.code.toLowerCase()) >= 0) {
                osType = osTypeWk;
                break;
            }
            ++n2;
        }
        return osType;
    }

    public static String getFileEncoding() {
        return System.getProperties().getProperty(BcJavaConstants.SysKey.sun_jnu_encoding.value);
    }

    public static enum OsType {
        Linux(11, "linux"),
        Windows(21, "windows"),
        Mac(31, "mac");

        public final int id;
        public final String code;

        private OsType(int id, String code) {
            this.id = id;
            this.code = code;
        }
    }
}

