/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.log;

import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;

public final class BcLogHelper {
    public static final char SPACE_REPLSE = BcUnicode.MIDDLE_DOT.char_;
    public static final char SPACE_REPLSE_FULLWIDTH = BcUnicode.FULLWIDTH_\u4e2d\u9ed2\u70b9.char_;

    private BcLogHelper() {
    }

    public static String integer(int dataId) throws Exception {
        return BcStringUtil.fillPrefix(BcNumberUtil.toString(dataId), 14, SPACE_REPLSE);
    }

    public static String integer10(int dataId) throws Exception {
        return BcStringUtil.fillPrefix(BcNumberUtil.toString(dataId), 10, SPACE_REPLSE);
    }

    public static String long_(long dataId) throws Exception {
        return BcStringUtil.fillPrefix(BcNumberUtil.toString(dataId), 14, SPACE_REPLSE);
    }

    public static String count(long sum, long cnt) throws Exception {
        StringBuilder sb = new StringBuilder();
        String sumStr = BcNumberUtil.toString(sum);
        sb.append(BcStringUtil.fillPrefix(cnt, sumStr.length(), ' '));
        sb.append("/");
        sb.append(sumStr);
        return sb.toString();
    }

    public static String countBrackets(long sum, long cnt, boolean percent) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(BcLogHelper.count(sum, cnt));
        sb.append("]");
        if (percent) {
            double d = (double)cnt / (double)sum * 100.0;
            sb.append(" ");
            sb.append(String.format("%.1f", d));
            sb.append("%");
        }
        return sb.toString();
    }

    public static String countBase0(long sum, long cnt) {
        StringBuilder sb = new StringBuilder();
        sb.append(cnt + 1L);
        sb.append("/");
        sb.append(sum);
        return sb.toString();
    }
}

