/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.core;

import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;

public final class BcUnicodeUtil {
    public static final char BS = '\b';
    public static final char HT = '\t';
    public static final char FULLWIDTH_SPACE = '\u3000';

    private BcUnicodeUtil() {
    }

    public static String replace(CharacterConverter characterConverter, String str) throws Exception {
        if (BcStringUtil.isEmpty(str)) {
            return str;
        }
        int i = 0;
        while (i < characterConverter.getCount()) {
            BcUnicode newUnicode = characterConverter.getNewUnicode(i);
            BcUnicode[] oldUnicodes = characterConverter.getOldUnicodes(i);
            int j = 0;
            while (j < oldUnicodes.length) {
                str = str.replace(oldUnicodes[j].char_, newUnicode.char_);
                ++j;
            }
            ++i;
        }
        return str;
    }

    public static enum Change implements CharacterConverter
    {
        SPACE(BcUnicode.space, BcUnicode.noBreakSpace),
        WAVE_DASH(BcUnicode.WAVE_DASH, BcUnicode.ILDE_OPERATOR, BcUnicode.REVERSED_TILDE, BcUnicode.INVERTED_LAZY_S, BcUnicode.SIGN_WAVE, BcUnicode.FULLWIDTH_TILDE);

        public final BcUnicode newUnicode;
        public final BcUnicode[] oldUnicodes;

        private Change(BcUnicode newUnicode, BcUnicode ... oldUnicodes) {
            this.newUnicode = newUnicode;
            this.oldUnicodes = oldUnicodes;
        }

        @Override
        public int getCount() {
            return Change.values().length;
        }

        @Override
        public BcUnicode getNewUnicode(int index) {
            Change characterConverter = BcLangUtil.getEnumByOrdinal(Change.class, index);
            return characterConverter.newUnicode;
        }

        @Override
        public BcUnicode[] getOldUnicodes(int index) {
            Change characterConverter = BcLangUtil.getEnumByOrdinal(Change.class, index);
            return characterConverter.oldUnicodes;
        }
    }

    public static interface CharacterConverter {
        public int getCount();

        public BcUnicode getNewUnicode(int var1);

        public BcUnicode[] getOldUnicodes(int var1);
    }
}

