/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.core;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.List;

public final class BcLangUtil {
    private BcLangUtil() {
    }

    public static Class toPrimitiveType(Class clazz) throws Exception {
        if (Integer.class.isAssignableFrom(clazz)) {
            return Integer.TYPE;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return Short.TYPE;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return Long.TYPE;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return Byte.TYPE;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return Double.TYPE;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return Float.TYPE;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return Character.TYPE;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return Boolean.TYPE;
        }
        throw new Exception(String.valueOf(clazz.getName()) + " \u306e\u30d7\u30ea\u30df\u30c6\u30a3\u30d6\u578b\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public static Class toWrapperClass(Class clazz) throws Exception {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        throw new Exception(String.valueOf(clazz.getName()) + " \u306e\u30e9\u30c3\u30d1\u30fc\u30af\u30e9\u30b9\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public static boolean isWrapperClass(Class clazz) throws Exception {
        return Integer.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz);
    }

    public static boolean isAssignableFrom(Class clazz, Object obj) throws Exception {
        if (obj == null) {
            return false;
        }
        return clazz.isAssignableFrom(obj.getClass());
    }

    public static boolean isByteArray(Class clazz) throws Exception {
        return clazz.isArray() && Byte.TYPE.isAssignableFrom(clazz.getComponentType());
    }

    public static Object getDefaultValue(Class clazz) throws Exception {
        Constable value = null;
        if (BcLangUtil.isWrapperClass(clazz)) {
            clazz = BcLangUtil.toPrimitiveType(clazz);
        }
        if (clazz == Integer.TYPE) {
            value = 0;
        } else if (clazz == Short.TYPE) {
            value = (short)0;
        } else if (clazz == Long.TYPE) {
            value = 0L;
        } else if (clazz == Byte.TYPE) {
            value = (byte)0;
        } else if (clazz == Double.TYPE) {
            value = 0.0;
        } else if (clazz == Float.TYPE) {
            value = Float.valueOf(0.0f);
        } else if (clazz == Character.TYPE) {
            value = Character.valueOf('0');
        } else if (clazz == Boolean.TYPE) {
            value = Boolean.valueOf(false);
        } else {
            throw new Exception("Not suported. class=" + clazz.getName());
        }
        return value;
    }

    public static <E extends Enum<E>> E getEnumByOrdinal(Class<E> enumClass, int ordinal) {
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        return (E)constants[ordinal];
    }

    public static <E extends Enum<E>> E getEnumByName(Class<E> enumClass, String name, boolean ignoreCase) {
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum constant = enumArray[n2];
            if (ignoreCase ? constant.name().equalsIgnoreCase(name) : constant.name().equals(name)) {
                return (E)constant;
            }
            ++n2;
        }
        return null;
    }

    public static <E extends Enum<E>> E getEnumByName(Class<E> enumClass, String name) {
        return BcLangUtil.getEnumByName(enumClass, name, false);
    }

    public static <E extends Enum<E>> List<E> toEnumList(Class<E> enumClass) throws Exception {
        ArrayList<Enum> enumList = new ArrayList<Enum>();
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum constant = enumArray[n2];
            enumList.add(constant);
            ++n2;
        }
        return enumList;
    }

    public static String toClassFileName(Class clazz) {
        return String.valueOf(clazz.getSimpleName()) + "." + "class";
    }

    public static String toPath(Package aPackage) {
        return String.valueOf(aPackage.getName().replaceAll("\\.", "/")) + "/";
    }

    public static Class<?> forName(String className, boolean initialize, ClassLoader classLoader) throws Exception {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, initialize, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception ex) {
            throw ex;
        }
        return clazz;
    }
}

