/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NimRODFontDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected JPanel fondo;
    protected JList lFont;
    protected JList lStyle;
    protected JList lSize;
    protected Font currentFont;
    protected JLabel lEjemplo;
    protected boolean bCancelado = true;

    public NimRODFontDialog(Frame papi) {
        this(papi, (Font)null);
    }

    public NimRODFontDialog(Frame papi, Font fIni) {
        super(papi, "Font", true);
        this.setDefaultCloseOperation(2);
        this.doPanel(fIni);
        this.getContentPane().add((Component)this.fondo, "Center");
        this.pack();
        this.setResizable(false);
    }

    public boolean isCanceled() {
        return this.bCancelado;
    }

    public Font getSelectedFont() {
        return this.currentFont;
    }

    public void doPanel(Font fIni) {
        String[] styles = new String[]{"Normal", "Bold", "Italic", "Bold+Italic"};
        String[] sizes = new String[100];
        int i = 1;
        while (i <= 100) {
            sizes[i - 1] = "" + i;
            ++i;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        MIListSelectionListener milsl = new MIListSelectionListener();
        this.lFont = new JList<String>(ge.getAvailableFontFamilyNames());
        this.lFont.setVisibleRowCount(7);
        this.lFont.addListSelectionListener(milsl);
        this.lStyle = new JList<String>(styles);
        this.lStyle.setVisibleRowCount(7);
        this.lStyle.addListSelectionListener(milsl);
        this.lSize = new JList<String>(sizes);
        this.lSize.setVisibleRowCount(7);
        this.lSize.addListSelectionListener(milsl);
        JLabel jLabel1 = new JLabel("Font");
        jLabel1.setBounds(10, 20, 41, 16);
        JLabel jLabel2 = new JLabel("Style");
        jLabel2.setBounds(170, 20, 41, 16);
        JLabel jLabel3 = new JLabel("Size");
        jLabel3.setBounds(270, 20, 41, 16);
        JScrollPane jsp1 = new JScrollPane(this.lFont);
        jsp1.setBounds(10, 40, 150, 110);
        JScrollPane jsp2 = new JScrollPane(this.lStyle);
        jsp2.setBounds(170, 40, 90, 110);
        JScrollPane jsp3 = new JScrollPane(this.lSize);
        jsp3.setBounds(270, 40, 70, 110);
        this.lEjemplo = new JLabel("AaBbCcDdEeFfGgHhIiJjKkLlMm...XxYyZz", 0);
        this.lEjemplo.setBounds(10, 160, 340, 49);
        JButton bOK = new JButton("OK");
        bOK.addActionListener(milsl);
        bOK.setBounds(265, 230, 75, 25);
        JButton bCancel = new JButton("Cancel");
        bCancel.addActionListener(milsl);
        bCancel.setBounds(180, 230, 75, 25);
        this.fondo = new JPanel(null);
        this.fondo.add(jLabel1);
        this.fondo.add(jLabel2);
        this.fondo.add(jLabel3);
        this.fondo.add(jsp1);
        this.fondo.add(jsp2);
        this.fondo.add(jsp3);
        this.fondo.add(this.lEjemplo);
        this.fondo.add(bOK);
        this.fondo.add(bCancel);
        this.fondo.setPreferredSize(new Dimension(350, 265));
        this.currentFont = fIni == null ? this.lEjemplo.getFont() : fIni;
        this.decode(this.currentFont);
    }

    private void decode(Font ff) {
        String fontName = ff.getFontName();
        int style = ff.getStyle();
        int size = ff.getSize();
        this.lFont.setSelectedValue(fontName, true);
        this.lSize.setSelectedValue("" + size, true);
        if ((style & 1) != 0 && (style & 2) != 0) {
            this.lStyle.setSelectedValue("Bold+Italic", true);
        } else if ((style & 1) != 0) {
            this.lStyle.setSelectedValue("Bold", true);
        } else if ((style & 2) != 0) {
            this.lStyle.setSelectedValue("Italic", true);
        } else {
            this.lStyle.setSelectedValue("Normal", true);
        }
    }

    public void refresh() {
        this.lEjemplo.setFont(this.currentFont);
    }

    protected class MIListSelectionListener
    implements ListSelectionListener,
    ActionListener {
        protected MIListSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("OK")) {
                NimRODFontDialog.this.bCancelado = false;
            } else if (e.getActionCommand().equals("Cancel")) {
                NimRODFontDialog.this.bCancelado = true;
            }
            NimRODFontDialog.this.dispose();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            String fontName = NimRODFontDialog.this.currentFont.getFontName();
            int style = NimRODFontDialog.this.currentFont.getStyle();
            int size = NimRODFontDialog.this.currentFont.getSize();
            if (NimRODFontDialog.this.lFont.getSelectedValue() != null) {
                fontName = (String)NimRODFontDialog.this.lFont.getSelectedValue();
            }
            if (NimRODFontDialog.this.lSize.getSelectedValue() != null) {
                size = Integer.decode((String)NimRODFontDialog.this.lSize.getSelectedValue());
            }
            if (NimRODFontDialog.this.lStyle.getSelectedValue() != null) {
                style = 0;
                String ss = (String)NimRODFontDialog.this.lStyle.getSelectedValue();
                if (ss.indexOf("Normal") != -1) {
                    style = 0;
                } else {
                    if (ss.indexOf("Italic") != -1) {
                        style = 2;
                    }
                    if (ss.indexOf("Bold") != -1) {
                        style |= 1;
                    }
                }
            }
            NimRODFontDialog.this.currentFont = new Font(fontName, style, size);
            NimRODFontDialog.this.refresh();
        }
    }
}

