/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class NimRODDesktopIconUI
extends BasicDesktopIconUI {
    boolean hasFocus;
    private int width = UIManager.getInt("NimRODDesktopIcon.width");
    private int height = UIManager.getInt("NimRODDesktopIcon.height");
    private int bigWidth = UIManager.getInt("NimRODDesktopIconBig.width");
    private int bigHeight = UIManager.getInt("NimRODDesktopIconBig.height");
    private HackML hackML = new HackML();
    private Icon resizeIcon;
    private Icon antIcon;

    public static ComponentUI createUI(JComponent c) {
        return new NimRODDesktopIconUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.uninstallBorder(this.desktopIcon);
    }

    @Override
    protected void installComponents() {
    }

    @Override
    protected void uninstallComponents() {
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.frame != null) {
            this.desktopIcon.addMouseListener(this.hackML);
            this.desktopIcon.addMouseMotionListener(this.hackML);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.desktopIcon.removeMouseListener(this.hackML);
        this.desktopIcon.removeMouseMotionListener(this.hackML);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.frame.getFrameIcon() != this.antIcon) {
            this.antIcon = this.frame.getFrameIcon();
            this.resizeIcon = NimRODUtils.reescala(this.antIcon, this.bigWidth, this.bigHeight);
        }
        String title = this.frame.getTitle();
        int x = 0;
        if (this.resizeIcon != null) {
            x = (this.width - this.resizeIcon.getIconWidth()) / 2;
            this.resizeIcon.paintIcon(c, g, x, 2);
        }
        g.setFont(UIManager.getFont("DesktopIcon.font"));
        FontMetrics fm = g.getFontMetrics();
        if (this.hasFocus) {
            int y = 0;
            String auxTit = this.getTitle(title, fm, this.width - 10);
            while (auxTit.length() > 0) {
                if (auxTit.endsWith("...")) {
                    auxTit = auxTit.substring(0, auxTit.length() - 3);
                }
                Rectangle2D rect = fm.getStringBounds(auxTit, g);
                x = (int)((double)this.width - rect.getWidth()) / 2;
                y = (int)((double)y + rect.getHeight());
                NimRODUtils.paintShadowTitleFat(g, auxTit, x, y, Color.white);
                title = title.substring(auxTit.length());
                auxTit = this.getTitle(title, fm, this.width - 10);
            }
        } else {
            title = this.getTitle(title, fm, this.width - 10);
            Rectangle2D rect = fm.getStringBounds(title, g);
            x = (int)((double)this.width - rect.getWidth()) / 2;
            NimRODUtils.paintShadowTitleFat(g, title, x, this.height - 5, Color.white);
        }
    }

    protected String getTitle(String title, FontMetrics fm, int len) {
        String aux;
        if (title == null || title.equals("")) {
            return "";
        }
        int lTit = fm.stringWidth(title);
        if (lTit <= len) {
            return title;
        }
        int lPuntos = fm.stringWidth("...");
        if (len - lPuntos <= 0) {
            return "";
        }
        int i = 1;
        while ((lPuntos = fm.stringWidth(aux = String.valueOf(title.substring(0, i++)) + "...")) < len) {
        }
        return String.valueOf(title.substring(0, i - 1)) + "...";
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.width, this.height);
    }

    private class HackML
    extends MouseInputAdapter {
        private HackML() {
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            this.dodo(ev);
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            this.dodo(ev);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            NimRODDesktopIconUI.this.hasFocus = false;
            this.dodo(ev);
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            NimRODDesktopIconUI.this.hasFocus = true;
            this.dodo(ev);
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            this.dodo(ev);
        }

        void dodo(MouseEvent ev) {
            if (NimRODDesktopIconUI.this.desktopIcon != null) {
                NimRODDesktopIconUI.this.desktopIcon.getDesktopPane().updateUI();
            }
        }
    }
}

