/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import sun.security.action.GetPropertyAction;
import sun.security.provider.NativePRNG;
import sun.security.util.SecurityProviderConstants;

public final class SunEntries {
    public static final String DEF_SECURE_RANDOM_ALGO;
    private LinkedHashSet<Provider.Service> services = new LinkedHashSet(50, 0.9f);
    private static final String PROP_EGD = "java.security.egd";
    private static final String PROP_RNDSOURCE = "securerandom.source";
    private static final boolean useLegacyDSA;
    static final String URL_DEV_RANDOM = "file:/dev/random";
    static final String URL_DEV_URANDOM = "file:/dev/urandom";
    private static final String seedSource;

    SunEntries(Provider provider) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("ThreadSafe", "true");
        if (NativePRNG.isAvailable()) {
            this.add(provider, "SecureRandom", "NativePRNG", "sun.security.provider.NativePRNG", hashMap);
        }
        if (NativePRNG.Blocking.isAvailable()) {
            this.add(provider, "SecureRandom", "NativePRNGBlocking", "sun.security.provider.NativePRNG$Blocking", hashMap);
        }
        if (NativePRNG.NonBlocking.isAvailable()) {
            this.add(provider, "SecureRandom", "NativePRNGNonBlocking", "sun.security.provider.NativePRNG$NonBlocking", hashMap);
        }
        hashMap.put("ImplementedIn", "Software");
        this.add(provider, "SecureRandom", "SHA1PRNG", "sun.security.provider.SecureRandom", hashMap);
        hashMap.clear();
        String string = "java.security.interfaces.DSAPublicKey|java.security.interfaces.DSAPrivateKey";
        hashMap.put("SupportedKeyClasses", string);
        hashMap.put("ImplementedIn", "Software");
        hashMap.put("KeySize", "1024");
        this.addWithAlias(provider, "Signature", "SHA1withDSA", "sun.security.provider.DSA$SHA1withDSA", hashMap);
        this.addWithAlias(provider, "Signature", "NONEwithDSA", "sun.security.provider.DSA$RawDSA", hashMap);
        hashMap.put("KeySize", "2048");
        this.addWithAlias(provider, "Signature", "SHA224withDSA", "sun.security.provider.DSA$SHA224withDSA", hashMap);
        this.addWithAlias(provider, "Signature", "SHA256withDSA", "sun.security.provider.DSA$SHA256withDSA", hashMap);
        hashMap.clear();
        hashMap.put("ImplementedIn", "Software");
        hashMap.put("KeySize", "2048");
        String string2 = "sun.security.provider.DSAKeyPairGenerator$";
        string2 = string2 + (useLegacyDSA ? "Legacy" : "Current");
        this.addWithAlias(provider, "KeyPairGenerator", "DSA", string2, hashMap);
        this.addWithAlias(provider, "AlgorithmParameterGenerator", "DSA", "sun.security.provider.DSAParameterGenerator", hashMap);
        hashMap.remove("KeySize");
        this.addWithAlias(provider, "AlgorithmParameters", "DSA", "sun.security.provider.DSAParameters", hashMap);
        this.addWithAlias(provider, "KeyFactory", "DSA", "sun.security.provider.DSAKeyFactory", hashMap);
        this.add(provider, "MessageDigest", "MD2", "sun.security.provider.MD2", hashMap);
        this.add(provider, "MessageDigest", "MD5", "sun.security.provider.MD5", hashMap);
        this.addWithAlias(provider, "MessageDigest", "SHA-1", "sun.security.provider.SHA", hashMap);
        this.addWithAlias(provider, "MessageDigest", "SHA-224", "sun.security.provider.SHA2$SHA224", hashMap);
        this.addWithAlias(provider, "MessageDigest", "SHA-256", "sun.security.provider.SHA2$SHA256", hashMap);
        this.addWithAlias(provider, "MessageDigest", "SHA-384", "sun.security.provider.SHA5$SHA384", hashMap);
        this.addWithAlias(provider, "MessageDigest", "SHA-512", "sun.security.provider.SHA5$SHA512", hashMap);
        this.addWithAlias(provider, "MessageDigest", "SHA-512/224", "sun.security.provider.SHA5$SHA512_224", hashMap);
        this.addWithAlias(provider, "MessageDigest", "SHA-512/256", "sun.security.provider.SHA5$SHA512_256", hashMap);
        this.addWithAlias(provider, "CertificateFactory", "X.509", "sun.security.provider.X509Factory", hashMap);
        this.add(provider, "KeyStore", "JKS", "sun.security.provider.JavaKeyStore$DualFormatJKS", hashMap);
        this.add(provider, "KeyStore", "CaseExactJKS", "sun.security.provider.JavaKeyStore$CaseExactJKS", hashMap);
        this.add(provider, "KeyStore", "DKS", "sun.security.provider.DomainKeyStore$DKS", hashMap);
        hashMap.clear();
        hashMap.put("LDAPSchema", "RFC2587");
        hashMap.put("ImplementedIn", "Software");
        this.add(provider, "CertStore", "LDAP", "sun.security.provider.certpath.ldap.LDAPCertStore", hashMap);
        hashMap.remove("LDAPSchema");
        this.add(provider, "CertStore", "Collection", "sun.security.provider.certpath.CollectionCertStore", hashMap);
        this.add(provider, "CertStore", "com.sun.security.IndexedCollection", "sun.security.provider.certpath.IndexedCollectionCertStore", hashMap);
        this.add(provider, "Policy", "JavaPolicy", "sun.security.provider.PolicySpiFile");
        this.add(provider, "Configuration", "JavaLoginConfig", "sun.security.provider.ConfigFile$Spi");
        hashMap.clear();
        hashMap.put("ValidationAlgorithm", "RFC5280");
        hashMap.put("ImplementedIn", "Software");
        this.add(provider, "CertPathBuilder", "PKIX", "sun.security.provider.certpath.SunCertPathBuilder", hashMap);
        this.add(provider, "CertPathValidator", "PKIX", "sun.security.provider.certpath.PKIXCertPathValidator", hashMap);
    }

    Iterator<Provider.Service> iterator() {
        return this.services.iterator();
    }

    private void add(Provider provider, String string, String string2, String string3) {
        this.services.add(new Provider.Service(provider, string, string2, string3, null, null));
    }

    private void add(Provider provider, String string, String string2, String string3, HashMap<String, String> hashMap) {
        this.services.add(new Provider.Service(provider, string, string2, string3, null, hashMap));
    }

    private void addWithAlias(Provider provider, String string, String string2, String string3, HashMap<String, String> hashMap) {
        this.services.add(new Provider.Service(provider, string, string2, string3, SecurityProviderConstants.getAliases(string2), hashMap));
    }

    static String getSeedSource() {
        return seedSource;
    }

    static File getDeviceFile(URL uRL) throws IOException {
        try {
            URI uRI = uRL.toURI();
            if (uRI.isOpaque()) {
                URI uRI2 = new File(System.getProperty("user.dir")).toURI();
                String string = uRI2.toString() + uRI.toString().substring(5);
                return new File(URI.create(string));
            }
            return new File(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(uRL.getPath());
        }
    }

    static {
        useLegacyDSA = Boolean.parseBoolean(GetPropertyAction.privilegedGetProperty("jdk.security.legacyDSAKeyPairGenerator"));
        seedSource = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string = System.getProperty(SunEntries.PROP_EGD, "");
                if (string.length() != 0) {
                    return string;
                }
                string = Security.getProperty(SunEntries.PROP_RNDSOURCE);
                if (string == null) {
                    return "";
                }
                return string;
            }
        });
        DEF_SECURE_RANDOM_ALGO = NativePRNG.isAvailable() && (seedSource.equals(URL_DEV_URANDOM) || seedSource.equals(URL_DEV_RANDOM)) ? "NativePRNG" : "SHA1PRNG";
    }
}

