/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.AbstractList;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.xs.datatypes.ObjectList;

public class ListDV
extends TypeValidator {
    @Override
    public short getAllowedFacets() {
        return 2079;
    }

    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        return content;
    }

    @Override
    public int getDataLength(Object value) {
        return ((ListData)value).getLength();
    }

    static final class ListData
    extends AbstractList
    implements ObjectList {
        final Object[] data;
        private String canonical;

        public ListData(Object[] data) {
            this.data = data;
        }

        @Override
        public synchronized String toString() {
            if (this.canonical == null) {
                int len = this.data.length;
                StringBuffer buf = new StringBuffer();
                if (len > 0) {
                    buf.append(this.data[0].toString());
                }
                int i = 1;
                while (i < len) {
                    buf.append(' ');
                    buf.append(this.data[i].toString());
                    ++i;
                }
                this.canonical = buf.toString();
            }
            return this.canonical;
        }

        @Override
        public int getLength() {
            return this.data.length;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ListData)) {
                return false;
            }
            int count = this.data.length;
            Object[] odata = ((ListData)obj).data;
            if (count != odata.length) {
                return false;
            }
            int i = 0;
            while (i < count) {
                if (!this.data[i].equals(odata[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.data.length) {
                hash ^= this.data[i].hashCode();
                ++i;
            }
            return hash;
        }

        @Override
        public boolean contains(Object item) {
            int i = 0;
            while (i < this.data.length) {
                if (item == this.data[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public Object item(int index) {
            if (index < 0 || index >= this.data.length) {
                return null;
            }
            return this.data[index];
        }

        public Object get(int index) {
            if (index >= 0 && index < this.data.length) {
                return this.data[index];
            }
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        public int size() {
            return this.getLength();
        }
    }
}

