/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netrexx.lang.Rexx;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

public class NetRexxC
extends MatchingTask {
    private boolean binary;
    private String classpath;
    private boolean comments;
    private boolean compact = true;
    private boolean compile = true;
    private boolean console;
    private boolean crossref;
    private boolean decimal = true;
    private File destDir;
    private boolean diag;
    private boolean explicit;
    private boolean format;
    private boolean keep;
    private boolean logo = true;
    private boolean replace;
    private boolean savelog;
    private File srcDir;
    private boolean sourcedir = true;
    private boolean strictargs;
    private boolean strictassign;
    private boolean strictcase;
    private boolean strictimport;
    private boolean strictprops;
    private boolean strictsignal;
    private boolean symbols;
    private boolean time;
    private String trace = "trace2";
    private boolean utf8;
    private String verbose = "verbose3";
    private boolean suppressMethodArgumentNotUsed = false;
    private boolean suppressPrivatePropertyNotUsed = false;
    private boolean suppressVariableNotUsed = false;
    private boolean suppressExceptionNotSignalled = false;
    private boolean suppressDeprecation = false;
    private boolean removeKeepExtension = false;
    static final String MSG_METHOD_ARGUMENT_NOT_USED = "Warning: Method argument is not used";
    static final String MSG_PRIVATE_PROPERTY_NOT_USED = "Warning: Private property is defined but not used";
    static final String MSG_VARIABLE_NOT_USED = "Warning: Variable is set but not used";
    static final String MSG_EXCEPTION_NOT_SIGNALLED = "is in SIGNALS list but is not signalled within the method";
    static final String MSG_DEPRECATION = "has been deprecated";
    private Vector compileList = new Vector();
    private Hashtable filecopyList = new Hashtable();

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
        if (!this.compile && !this.keep) {
            this.keep = true;
        }
    }

    public void setConsole(boolean console) {
        this.console = console;
    }

    public void setCrossref(boolean crossref) {
        this.crossref = crossref;
    }

    public void setDecimal(boolean decimal) {
        this.decimal = decimal;
    }

    public void setDestDir(File destDirName) {
        this.destDir = destDirName;
    }

    public void setDiag(boolean diag) {
        this.diag = diag;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public void setJava(boolean java) {
        this.log("The attribute java is currently unused.", 1);
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public void setLogo(boolean logo) {
        this.logo = logo;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public void setSavelog(boolean savelog) {
        this.savelog = savelog;
    }

    public void setSourcedir(boolean sourcedir) {
        this.sourcedir = sourcedir;
    }

    public void setSrcDir(File srcDirName) {
        this.srcDir = srcDirName;
    }

    public void setStrictargs(boolean strictargs) {
        this.strictargs = strictargs;
    }

    public void setStrictassign(boolean strictassign) {
        this.strictassign = strictassign;
    }

    public void setStrictcase(boolean strictcase) {
        this.strictcase = strictcase;
    }

    public void setStrictimport(boolean strictimport) {
        this.strictimport = strictimport;
    }

    public void setStrictprops(boolean strictprops) {
        this.strictprops = strictprops;
    }

    public void setStrictsignal(boolean strictsignal) {
        this.strictsignal = strictsignal;
    }

    public void setSymbols(boolean symbols) {
        this.symbols = symbols;
    }

    public void setTime(boolean time) {
        this.time = time;
    }

    public void setTrace(TraceAttr trace) {
        this.trace = trace.getValue();
    }

    public void setTrace(String trace) {
        TraceAttr t = new TraceAttr();
        t.setValue(trace);
        this.setTrace(t);
    }

    public void setUtf8(boolean utf8) {
        this.utf8 = utf8;
    }

    public void setVerbose(VerboseAttr verbose) {
        this.verbose = verbose.getValue();
    }

    public void setVerbose(String verbose) {
        VerboseAttr v = new VerboseAttr();
        v.setValue(verbose);
        this.setVerbose(v);
    }

    public void setSuppressMethodArgumentNotUsed(boolean suppressMethodArgumentNotUsed) {
        this.suppressMethodArgumentNotUsed = suppressMethodArgumentNotUsed;
    }

    public void setSuppressPrivatePropertyNotUsed(boolean suppressPrivatePropertyNotUsed) {
        this.suppressPrivatePropertyNotUsed = suppressPrivatePropertyNotUsed;
    }

    public void setSuppressVariableNotUsed(boolean suppressVariableNotUsed) {
        this.suppressVariableNotUsed = suppressVariableNotUsed;
    }

    public void setSuppressExceptionNotSignalled(boolean suppressExceptionNotSignalled) {
        this.suppressExceptionNotSignalled = suppressExceptionNotSignalled;
    }

    public void setSuppressDeprecation(boolean suppressDeprecation) {
        this.suppressDeprecation = suppressDeprecation;
    }

    public void setRemoveKeepExtension(boolean removeKeepExtension) {
        this.removeKeepExtension = removeKeepExtension;
    }

    @Override
    public void init() {
        String p = this.getProject().getProperty("ant.netrexxc.binary");
        if (p != null) {
            this.binary = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.comments")) != null) {
            this.comments = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.compact")) != null) {
            this.compact = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.compile")) != null) {
            this.compile = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.console")) != null) {
            this.console = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.crossref")) != null) {
            this.crossref = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.decimal")) != null) {
            this.decimal = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.diag")) != null) {
            this.diag = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.explicit")) != null) {
            this.explicit = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.format")) != null) {
            this.format = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.keep")) != null) {
            this.keep = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.logo")) != null) {
            this.logo = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.replace")) != null) {
            this.replace = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.savelog")) != null) {
            this.savelog = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.sourcedir")) != null) {
            this.sourcedir = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.strictargs")) != null) {
            this.strictargs = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.strictassign")) != null) {
            this.strictassign = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.strictcase")) != null) {
            this.strictcase = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.strictimport")) != null) {
            this.strictimport = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.strictprops")) != null) {
            this.strictprops = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.strictsignal")) != null) {
            this.strictsignal = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.symbols")) != null) {
            this.symbols = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.time")) != null) {
            this.time = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.trace")) != null) {
            this.setTrace(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.utf8")) != null) {
            this.utf8 = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.verbose")) != null) {
            this.setVerbose(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.suppressMethodArgumentNotUsed")) != null) {
            this.suppressMethodArgumentNotUsed = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.suppressPrivatePropertyNotUsed")) != null) {
            this.suppressPrivatePropertyNotUsed = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.suppressVariableNotUsed")) != null) {
            this.suppressVariableNotUsed = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.suppressExceptionNotSignalled")) != null) {
            this.suppressExceptionNotSignalled = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.suppressDeprecation")) != null) {
            this.suppressDeprecation = Project.toBoolean(p);
        }
        if ((p = this.getProject().getProperty("ant.netrexxc.removeKeepExtension")) != null) {
            this.removeKeepExtension = Project.toBoolean(p);
        }
    }

    @Override
    public void execute() throws BuildException {
        if (this.srcDir == null || this.destDir == null) {
            throw new BuildException("srcDir and destDir attributes must be set!");
        }
        DirectoryScanner ds = this.getDirectoryScanner(this.srcDir);
        String[] files = ds.getIncludedFiles();
        this.scanDir(this.srcDir, this.destDir, files);
        this.copyFilesToDestination();
        if (this.compileList.size() > 0) {
            this.log("Compiling " + this.compileList.size() + " source file" + (this.compileList.size() == 1 ? "" : "s") + " to " + this.destDir);
            this.doNetRexxCompile();
            if (this.removeKeepExtension && (!this.compile || this.keep)) {
                this.removeKeepExtensions();
            }
        }
    }

    private void scanDir(File srcDir, File destDir, String[] files) {
        int i = 0;
        while (i < files.length) {
            File srcFile = new File(srcDir, files[i]);
            File destFile = new File(destDir, files[i]);
            String filename = files[i];
            if (filename.toLowerCase().endsWith(".nrx")) {
                File classFile = new File(destDir, String.valueOf(filename.substring(0, filename.lastIndexOf(46))) + ".class");
                File javaFile = new File(destDir, String.valueOf(filename.substring(0, filename.lastIndexOf(46))) + (this.removeKeepExtension ? ".java" : ".java.keep"));
                if (!this.compile && srcFile.lastModified() > javaFile.lastModified()) {
                    this.filecopyList.put(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
                    this.compileList.addElement(destFile.getAbsolutePath());
                } else if (this.compile && srcFile.lastModified() > classFile.lastModified()) {
                    this.filecopyList.put(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
                    this.compileList.addElement(destFile.getAbsolutePath());
                }
            } else if (srcFile.lastModified() > destFile.lastModified()) {
                this.filecopyList.put(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
            }
            ++i;
        }
    }

    private void copyFilesToDestination() {
        if (this.filecopyList.size() > 0) {
            this.log("Copying " + this.filecopyList.size() + " file" + (this.filecopyList.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            Enumeration e = this.filecopyList.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                String toFile = (String)this.filecopyList.get(fromFile);
                try {
                    FileUtils.getFileUtils().copyFile(fromFile, toFile);
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg, ioe);
                }
            }
        }
    }

    private void removeKeepExtensions() {
        if (this.compileList.size() > 0) {
            this.log("Removing .keep extension on " + this.compileList.size() + " file" + (this.compileList.size() == 1 ? "" : "s"));
            Enumeration e = this.compileList.elements();
            while (e.hasMoreElements()) {
                File toFile;
                String nrxName = (String)e.nextElement();
                String baseName = nrxName.substring(0, nrxName.lastIndexOf(46));
                File fromFile = new File(String.valueOf(baseName) + ".java.keep");
                if (fromFile.renameTo(toFile = new File(String.valueOf(baseName) + ".java"))) {
                    this.log("Successfully renamed " + fromFile + " to " + toFile, 3);
                    continue;
                }
                this.log("Failed to rename " + fromFile + " to " + toFile);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doNetRexxCompile() throws BuildException {
        this.log("Using NetRexx compiler", 3);
        classpath = this.getCompileClasspath();
        compileOptions = new StringBuffer();
        compileOptionsArray = this.getCompileOptionsAsArray();
        fileListArray = new String[this.compileList.size()];
        e = this.compileList.elements();
        j = 0;
        while (e.hasMoreElements()) {
            fileListArray[j] = (String)e.nextElement();
            ++j;
        }
        compileArgs = new String[compileOptionsArray.length + fileListArray.length];
        i = 0;
        while (i < compileOptionsArray.length) {
            compileArgs[i] = compileOptionsArray[i];
            ++i;
        }
        i = 0;
        while (i < fileListArray.length) {
            compileArgs[i + compileOptionsArray.length] = fileListArray[i];
            ++i;
        }
        compileOptions.append("Compilation args: ");
        i = 0;
        while (i < compileOptionsArray.length) {
            compileOptions.append(compileOptionsArray[i]);
            compileOptions.append(" ");
            ++i;
        }
        this.log(compileOptions.toString(), 3);
        eol = System.getProperty("line.separator");
        niceSourceList = new StringBuffer("Files to be compiled:" + eol);
        size = this.compileList.size();
        i = 0;
        while (i < size) {
            niceSourceList.append("    ");
            niceSourceList.append(this.compileList.elementAt(i).toString());
            niceSourceList.append(eol);
            ++i;
        }
        this.log(niceSourceList.toString(), 3);
        currentClassPath = System.getProperty("java.class.path");
        currentProperties = System.getProperties();
        currentProperties.put("java.class.path", classpath);
        try {
            try {
                out = new StringWriter();
                w = null;
                w = new PrintWriter(out);
                rc = COM.ibm.netrexx.process.NetRexxC.main((Rexx)new Rexx(compileArgs), (PrintWriter)w);
                sdir = this.srcDir.getAbsolutePath();
                ddir = this.destDir.getAbsolutePath();
                doReplace = sdir.equals(ddir) == false;
                dlen = ddir.length();
                in = new BufferedReader(new StringReader(out.toString()));
                this.log("replacing destdir '" + ddir + "' through sourcedir '" + sdir + "'", 3);
                ** GOTO lbl90
                {
                    l = new StringBuffer(l).replace(idx, idx + dlen, sdir).toString();
                    do {
                        if (doReplace && (idx = l.indexOf(ddir)) != -1) continue block10;
                        if (this.suppressMethodArgumentNotUsed && l.indexOf("Warning: Method argument is not used") != -1) {
                            this.log(l, 3);
                            continue;
                        }
                        if (this.suppressPrivatePropertyNotUsed && l.indexOf("Warning: Private property is defined but not used") != -1) {
                            this.log(l, 3);
                            continue;
                        }
                        if (this.suppressVariableNotUsed && l.indexOf("Warning: Variable is set but not used") != -1) {
                            this.log(l, 3);
                            continue;
                        }
                        if (this.suppressExceptionNotSignalled && l.indexOf("is in SIGNALS list but is not signalled within the method") != -1) {
                            this.log(l, 3);
                            continue;
                        }
                        if (this.suppressDeprecation && l.indexOf("has been deprecated") != -1) {
                            this.log(l, 3);
                            continue;
                        }
                        if (l.indexOf("Error:") != -1) {
                            this.log(l, 0);
                            continue;
                        }
                        if (l.indexOf("Warning:") != -1) {
                            this.log(l, 1);
                            continue;
                        }
                        this.log(l, 2);
lbl90:
                        // 9 sources

                    } while ((l = in.readLine()) != null);
                }
                if (rc > 1) {
                    throw new BuildException("Compile failed, messages should have been provided.");
                }
                if (w.checkError()) {
                    throw new IOException("Encountered an error");
                }
            }
            catch (IOException ioe) {
                throw new BuildException("Unexpected IOException while playing with Strings", ioe);
            }
        }
        finally {
            currentProperties = System.getProperties();
            currentProperties.put("java.class.path", currentClassPath);
        }
    }

    private String getCompileClasspath() {
        StringBuffer classpath = new StringBuffer();
        classpath.append(this.destDir.getAbsolutePath());
        if (this.classpath != null) {
            this.addExistingToClasspath(classpath, this.classpath);
        }
        return classpath.toString();
    }

    private String[] getCompileOptionsAsArray() {
        Vector<String> options = new Vector<String>();
        options.addElement(this.binary ? "-binary" : "-nobinary");
        options.addElement(this.comments ? "-comments" : "-nocomments");
        options.addElement(this.compile ? "-compile" : "-nocompile");
        options.addElement(this.compact ? "-compact" : "-nocompact");
        options.addElement(this.console ? "-console" : "-noconsole");
        options.addElement(this.crossref ? "-crossref" : "-nocrossref");
        options.addElement(this.decimal ? "-decimal" : "-nodecimal");
        options.addElement(this.diag ? "-diag" : "-nodiag");
        options.addElement(this.explicit ? "-explicit" : "-noexplicit");
        options.addElement(this.format ? "-format" : "-noformat");
        options.addElement(this.keep ? "-keep" : "-nokeep");
        options.addElement(this.logo ? "-logo" : "-nologo");
        options.addElement(this.replace ? "-replace" : "-noreplace");
        options.addElement(this.savelog ? "-savelog" : "-nosavelog");
        options.addElement(this.sourcedir ? "-sourcedir" : "-nosourcedir");
        options.addElement(this.strictargs ? "-strictargs" : "-nostrictargs");
        options.addElement(this.strictassign ? "-strictassign" : "-nostrictassign");
        options.addElement(this.strictcase ? "-strictcase" : "-nostrictcase");
        options.addElement(this.strictimport ? "-strictimport" : "-nostrictimport");
        options.addElement(this.strictprops ? "-strictprops" : "-nostrictprops");
        options.addElement(this.strictsignal ? "-strictsignal" : "-nostrictsignal");
        options.addElement(this.symbols ? "-symbols" : "-nosymbols");
        options.addElement(this.time ? "-time" : "-notime");
        options.addElement("-" + this.trace);
        options.addElement(this.utf8 ? "-utf8" : "-noutf8");
        options.addElement("-" + this.verbose);
        Object[] results = new String[options.size()];
        options.copyInto(results);
        return results;
    }

    private void addExistingToClasspath(StringBuffer target, String source) {
        StringTokenizer tok = new StringTokenizer(source, System.getProperty("path.separator"), false);
        while (tok.hasMoreTokens()) {
            File f = this.getProject().resolveFile(tok.nextToken());
            if (f.exists()) {
                target.append(File.pathSeparator);
                target.append(f.getAbsolutePath());
                continue;
            }
            this.log("Dropping from classpath: " + f.getAbsolutePath(), 3);
        }
    }

    public static class TraceAttr
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"trace", "trace1", "trace2", "notrace"};
        }
    }

    public static class VerboseAttr
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"verbose", "verbose0", "verbose1", "verbose2", "verbose3", "verbose4", "verbose5", "noverbose"};
        }
    }
}

