/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.email;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.email.Header;
import org.apache.tools.ant.taskdefs.email.Mailer;
import org.apache.tools.mail.MailMessage;

class PlainMailer
extends Mailer {
    PlainMailer() {
    }

    @Override
    public void send() {
        try {
            String to;
            MailMessage mailMessage = new MailMessage(this.host, this.port);
            mailMessage.from(this.from.toString());
            boolean atLeastOneRcptReached = false;
            Enumeration e = this.replyToList.elements();
            while (e.hasMoreElements()) {
                mailMessage.replyto(e.nextElement().toString());
            }
            e = this.toList.elements();
            while (e.hasMoreElements()) {
                to = e.nextElement().toString();
                try {
                    mailMessage.to(to);
                    atLeastOneRcptReached = true;
                }
                catch (IOException ex) {
                    this.badRecipient(to, ex);
                }
            }
            e = this.ccList.elements();
            while (e.hasMoreElements()) {
                to = e.nextElement().toString();
                try {
                    mailMessage.cc(to);
                    atLeastOneRcptReached = true;
                }
                catch (IOException ex) {
                    this.badRecipient(to, ex);
                }
            }
            e = this.bccList.elements();
            while (e.hasMoreElements()) {
                to = e.nextElement().toString();
                try {
                    mailMessage.bcc(to);
                    atLeastOneRcptReached = true;
                }
                catch (IOException ex) {
                    this.badRecipient(to, ex);
                }
            }
            if (!atLeastOneRcptReached) {
                throw new BuildException("Couldn't reach any recipient");
            }
            if (this.subject != null) {
                mailMessage.setSubject(this.subject);
            }
            mailMessage.setHeader("Date", this.getDate());
            if (this.message.getCharset() != null) {
                mailMessage.setHeader("Content-Type", String.valueOf(this.message.getMimeType()) + "; charset=\"" + this.message.getCharset() + "\"");
            } else {
                mailMessage.setHeader("Content-Type", this.message.getMimeType());
            }
            if (this.headers != null) {
                e = this.headers.elements();
                while (e.hasMoreElements()) {
                    Header h = (Header)e.nextElement();
                    mailMessage.setHeader(h.getName(), h.getValue());
                }
            }
            PrintStream out = mailMessage.getPrintStream();
            this.message.print(out);
            e = this.files.elements();
            while (e.hasMoreElements()) {
                this.attach((File)e.nextElement(), out);
            }
            mailMessage.sendAndClose();
        }
        catch (IOException ioe) {
            throw new BuildException("IO error sending mail", ioe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void attach(File file, PrintStream out) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new BuildException("File \"" + file.getName() + "\" does not exist or is not " + "readable.");
        }
        if (this.includeFileNames) {
            out.println();
            String filename = file.getName();
            int filenamelength = filename.length();
            out.println(filename);
            int star = 0;
            while (star < filenamelength) {
                out.print('=');
                ++star;
            }
            out.println();
        }
        int maxBuf = 1024;
        byte[] buf = new byte[1024];
        Throwable throwable = null;
        Object var7_10 = null;
        try {
            FileInputStream finstr = new FileInputStream(file);
            try {
                try (BufferedInputStream in = new BufferedInputStream(finstr, buf.length);){
                    int length;
                    while ((length = in.read(buf)) != -1) {
                        out.write(buf, 0, length);
                    }
                }
                if (finstr == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (finstr == null) throw throwable;
                finstr.close();
                throw throwable;
            }
            finstr.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void badRecipient(String rcpt, IOException reason) {
        String msg = "Failed to send mail to " + rcpt;
        if (this.shouldIgnoreInvalidRecipients()) {
            msg = String.valueOf(msg) + " because of :" + reason.getMessage();
            if (this.task != null) {
                this.task.log(msg, 1);
            } else {
                System.err.println(msg);
            }
        } else {
            throw new BuildException(msg, reason);
        }
    }
}

