/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Policies", category="Core", printObject=true)
public final class CompositeTriggeringPolicy
extends AbstractTriggeringPolicy {
    private final TriggeringPolicy[] triggeringPolicies;

    private CompositeTriggeringPolicy(TriggeringPolicy ... triggeringPolicies) {
        this.triggeringPolicies = triggeringPolicies;
    }

    public TriggeringPolicy[] getTriggeringPolicies() {
        return this.triggeringPolicies;
    }

    @Override
    public void initialize(RollingFileManager manager) {
        TriggeringPolicy[] triggeringPolicyArray = this.triggeringPolicies;
        int n = this.triggeringPolicies.length;
        int n2 = 0;
        while (n2 < n) {
            TriggeringPolicy triggeringPolicy = triggeringPolicyArray[n2];
            LOGGER.debug("Initializing triggering policy {}", (Object)triggeringPolicy.toString());
            triggeringPolicy.initialize(manager);
            ++n2;
        }
    }

    @Override
    public boolean isTriggeringEvent(LogEvent event) {
        TriggeringPolicy[] triggeringPolicyArray = this.triggeringPolicies;
        int n = this.triggeringPolicies.length;
        int n2 = 0;
        while (n2 < n) {
            TriggeringPolicy triggeringPolicy = triggeringPolicyArray[n2];
            if (triggeringPolicy.isTriggeringEvent(event)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @PluginFactory
    public static CompositeTriggeringPolicy createPolicy(TriggeringPolicy ... triggeringPolicy) {
        return new CompositeTriggeringPolicy(triggeringPolicy);
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = true;
        TriggeringPolicy[] triggeringPolicyArray = this.triggeringPolicies;
        int n = this.triggeringPolicies.length;
        int n2 = 0;
        while (n2 < n) {
            TriggeringPolicy triggeringPolicy = triggeringPolicyArray[n2];
            if (triggeringPolicy instanceof LifeCycle2) {
                stopped &= ((LifeCycle2)((Object)triggeringPolicy)).stop(timeout, timeUnit);
            } else if (triggeringPolicy instanceof LifeCycle) {
                ((LifeCycle)((Object)triggeringPolicy)).stop();
                stopped &= true;
            }
            ++n2;
        }
        this.setStopped();
        return stopped;
    }

    public String toString() {
        return "CompositeTriggeringPolicy(policies=" + Arrays.toString(this.triggeringPolicies) + ")";
    }
}

