/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.tftp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;

public abstract class TFTPRequestPacket
extends TFTPPacket {
    static final String[] modeStrings = new String[]{"netascii", "octet"};
    private static final byte[][] modeBytes;
    private final int mode;
    private final String fileName;

    static {
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray = new byte[9];
        byArray[0] = 110;
        byArray[1] = 101;
        byArray[2] = 116;
        byArray[3] = 97;
        byArray[4] = 115;
        byArray[5] = 99;
        byArray[6] = 105;
        byArray[7] = 105;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[0] = 111;
        byArray2[1] = 99;
        byArray2[2] = 116;
        byArray2[3] = 101;
        byArray2[4] = 116;
        byArrayArray[1] = byArray2;
        modeBytes = byArrayArray;
    }

    TFTPRequestPacket(InetAddress destination, int port, int type, String fileName, int mode) {
        super(type, destination, port);
        this.fileName = fileName;
        this.mode = mode;
    }

    TFTPRequestPacket(int type, DatagramPacket datagram) throws TFTPPacketException {
        super(type, datagram.getAddress(), datagram.getPort());
        byte[] data = datagram.getData();
        if (this.getType() != data[1]) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        StringBuilder buffer = new StringBuilder();
        int index = 2;
        int length = datagram.getLength();
        while (index < length && data[index] != 0) {
            buffer.append((char)data[index]);
            ++index;
        }
        this.fileName = buffer.toString();
        if (index >= length) {
            throw new TFTPPacketException("Bad file name and mode format.");
        }
        buffer.setLength(0);
        ++index;
        while (index < length && data[index] != 0) {
            buffer.append((char)data[index]);
            ++index;
        }
        String modeString = buffer.toString().toLowerCase(Locale.ENGLISH);
        length = modeStrings.length;
        int mode = 0;
        index = 0;
        while (index < length) {
            if (modeString.equals(modeStrings[index])) {
                mode = index;
                break;
            }
            ++index;
        }
        this.mode = mode;
        if (index >= length) {
            throw new TFTPPacketException("Unrecognized TFTP transfer mode: " + modeString);
        }
    }

    public final String getFilename() {
        return this.fileName;
    }

    public final int getMode() {
        return this.mode;
    }

    @Override
    public final DatagramPacket newDatagram() {
        int fileLength = this.fileName.length();
        int modeLength = modeBytes[this.mode].length;
        byte[] data = new byte[fileLength + modeLength + 4];
        data[0] = 0;
        data[1] = (byte)this.type;
        System.arraycopy(this.fileName.getBytes(Charset.defaultCharset()), 0, data, 2, fileLength);
        data[fileLength + 2] = 0;
        System.arraycopy(modeBytes[this.mode], 0, data, fileLength + 3, modeLength);
        return new DatagramPacket(data, data.length, this.address, this.port);
    }

    @Override
    final DatagramPacket newDatagram(DatagramPacket datagram, byte[] data) {
        int fileLength = this.fileName.length();
        int modeLength = modeBytes[this.mode].length;
        data[0] = 0;
        data[1] = (byte)this.type;
        System.arraycopy(this.fileName.getBytes(Charset.defaultCharset()), 0, data, 2, fileLength);
        data[fileLength + 2] = 0;
        System.arraycopy(modeBytes[this.mode], 0, data, fileLength + 3, modeLength);
        datagram.setAddress(this.address);
        datagram.setPort(this.port);
        datagram.setData(data);
        datagram.setLength(fileLength + modeLength + 3);
        return datagram;
    }
}

