/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.ftp;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.Util;

public final class ServerToServerFTP {
    public static void main(String[] args) {
        int reply;
        String server1;
        String[] parts;
        int port1 = 0;
        int port2 = 0;
        if (args.length < 8) {
            System.err.println("Usage: ftp <host1> <user1> <pass1> <file1> <host2> <user2> <pass2> <file2>");
            System.exit(1);
        }
        if ((parts = (server1 = args[0]).split(":")).length == 2) {
            server1 = parts[0];
            port1 = Integer.parseInt(parts[1]);
        }
        String user1 = args[1];
        String password1 = args[2];
        String file1 = args[3];
        String server2 = args[4];
        parts = server2.split(":");
        if (parts.length == 2) {
            server2 = parts[0];
            port2 = Integer.parseInt(parts[1]);
        }
        String user2 = args[5];
        String password2 = args[6];
        String file2 = args[7];
        PrintCommandListener listener = new PrintCommandListener(Util.newPrintWriter(System.out), true);
        FTPClient ftp1 = new FTPClient();
        ftp1.addProtocolCommandListener(listener);
        FTPClient ftp2 = new FTPClient();
        ftp2.addProtocolCommandListener(listener);
        try {
            if (port1 > 0) {
                ftp1.connect(server1, port1);
            } else {
                ftp1.connect(server1);
            }
            System.out.println("Connected to " + server1 + ".");
            reply = ftp1.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                ftp1.disconnect();
                System.err.println("FTP server1 refused connection.");
                System.exit(1);
            }
        }
        catch (IOException e) {
            if (ftp1.isConnected()) {
                try {
                    ftp1.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.err.println("Could not connect to server1.");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            if (port2 > 0) {
                ftp2.connect(server2, port2);
            } else {
                ftp2.connect(server2);
            }
            System.out.println("Connected to " + server2 + ".");
            reply = ftp2.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                ftp2.disconnect();
                System.err.println("FTP server2 refused connection.");
                System.exit(1);
            }
        }
        catch (IOException e) {
            if (ftp2.isConnected()) {
                try {
                    ftp2.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.err.println("Could not connect to server2.");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            if (!ftp1.login(user1, password1)) {
                System.err.println("Could not login to " + server1);
            } else if (!ftp2.login(user2, password2)) {
                System.err.println("Could not login to " + server2);
            } else {
                ftp2.enterRemotePassiveMode();
                ftp1.enterRemoteActiveMode(InetAddress.getByName(ftp2.getPassiveHost()), ftp2.getPassivePort());
                if (!ftp1.remoteRetrieve(file1) || !ftp2.remoteStoreUnique(file2)) {
                    System.err.println("Couldn't initiate transfer. Check that file names are valid.");
                } else {
                    try {
                        ftp1.completePendingCommand();
                        ftp2.completePendingCommand();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            }
        }
        finally {
            try {
                if (ftp1.isConnected()) {
                    ftp1.logout();
                    ftp1.disconnect();
                }
            }
            catch (IOException iOException) {}
            try {
                if (ftp2.isConnected()) {
                    ftp2.logout();
                    ftp2.disconnect();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

