/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.scf5.dao.ScfPropertyEventHandler;
import jp.co.extreme.scf5.model.ZScfIntProperties;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class ZScfAbstractIntPropertyDAO
extends OrmAbstractDAO {
    protected String tableName;
    protected String dataIdColumnName = "data_id";
    protected String itemIdColumnName = "item_id";
    protected String valueColumnName = "value_";
    protected Map<String, String> propMap = new HashMap<String, String>();
    protected List<ScfPropertyEventHandler> propertyEventHandlerList = new ArrayList<ScfPropertyEventHandler>();

    public ZScfAbstractIntPropertyDAO() {
        super(new Object[0]);
    }

    public void addEventHandler(ScfPropertyEventHandler eventHandler) {
        this.propertyEventHandlerList.add(eventHandler);
    }

    public void removeEventHandler(ScfPropertyEventHandler eventHandler) {
        this.propertyEventHandlerList.remove(eventHandler);
    }

    public void removeCash(int dataId, int itemId, boolean doNitify) throws Exception {
        this.propMap.remove(this.createKey(dataId, itemId));
        Object[] eventHandlers = this.propertyEventHandlerList.toArray();
        int i2 = 0;
        while (i2 < eventHandlers.length) {
            ScfPropertyEventHandler eventHandler = (ScfPropertyEventHandler)eventHandlers[i2];
            try {
                eventHandler.propertyRemoved(dataId, itemId);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            ++i2;
        }
        if (doNitify) {
            try {
                Object[] i2 = new Object[]{"removeCash", dataId, itemId};
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    public void clearCash() throws Exception {
        this.propMap.clear();
        Object[] eventHandlers = this.propertyEventHandlerList.toArray();
        int i = 0;
        while (i < eventHandlers.length) {
            ScfPropertyEventHandler eventHandler = (ScfPropertyEventHandler)eventHandlers[i];
            try {
                eventHandler.propertyRemoved(-1, -1);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            ++i;
        }
    }

    public void clearCash2() throws Exception {
        this.clearCash();
        try {
            Object[] objectArray = new Object[]{"clearCash"};
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDataIdColumnName() {
        return this.dataIdColumnName;
    }

    public void setDataIdColumnName(String dataIdColumnName) {
        this.dataIdColumnName = dataIdColumnName;
    }

    public String getItemIdColumnName() {
        return this.itemIdColumnName;
    }

    public void setItemIdColumnName(String itemIdColumnName) {
        this.itemIdColumnName = itemIdColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setValueColumnName(String valueColumnName) {
        this.valueColumnName = valueColumnName;
    }

    public void putProperty(DtsSession dtsSession, int dataId, int itemId, String value) throws Exception {
        this.putProperty2(dtsSession, dataId, itemId, value);
        this.removeCash(dataId, itemId, true);
    }

    protected int putProperty2(DtsSession dtsSession, int dataId, int itemId, String value) throws Exception {
        if (BcStringUtil.isEmpty(value)) {
            this.removeCash(dataId, itemId, false);
            this.deleteProperty2(dtsSession, dataId, itemId);
            return 0;
        }
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "UPDATE " + this.tableName + " SET " + this.valueColumnName + "=" + sqlContext.toSet(value) + " WHERE " + this.dataIdColumnName + "=" + dataId + " AND " + this.itemIdColumnName + "=" + itemId;
        int recCnt = 0;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            recCnt = stmt.executeUpdate(query);
        }
        if (recCnt > 0) {
            return recCnt;
        }
        query = "INSERT INTO " + this.tableName + " (" + " " + this.dataIdColumnName + "," + this.itemIdColumnName + "," + this.valueColumnName + ") VALUES (" + dataId + "," + itemId + "," + sqlContext.toSet(value) + ")";
        stmt = dtsSession.getConnection().createStatement();
        try {
            recCnt = stmt.executeUpdate(query);
        }
        finally {
            stmt.close();
        }
        return recCnt;
    }

    public String createKey(int dataId, int itemId) throws Exception {
        return String.valueOf(Integer.toString(dataId)) + "-" + Integer.toString(itemId);
    }

    public void putProperties(DtsSession dtsSession, int dataId, ZScfIntProperties intProps, boolean isOverwrite) throws Exception {
        try {
            Object[] keys = intProps.keySet().toArray();
            Arrays.sort(keys);
            int i = 0;
            while (i < keys.length) {
                Integer itemId = (Integer)keys[i];
                String value = intProps.get(itemId);
                if (isOverwrite) {
                    this.putProperty2(dtsSession, dataId, itemId, value);
                } else {
                    String tmpValue = this.getProperty(dtsSession, dataId, itemId);
                    if (BcStringUtil.isEmpty(tmpValue)) {
                        this.putProperty2(dtsSession, dataId, itemId, value);
                    }
                }
                ++i;
            }
        }
        finally {
            this.clearCash2();
        }
    }

    public void putProperties(DtsSession dtsSession, int dataId, ZScfIntProperties intProps) throws Exception {
        this.putProperties(dtsSession, dataId, intProps, true);
    }

    public void putPropertiesNewItemOnly(DtsSession dtsSession, int dataId, ZScfIntProperties intProps) throws Exception {
        this.putProperties(dtsSession, dataId, intProps, false);
    }

    public int deleteProperty(DtsSession dtsSession, int dataId, int itemId) throws Exception {
        this.removeCash(dataId, itemId, true);
        return this.deleteProperty2(dtsSession, dataId, itemId);
    }

    protected int deleteProperty2(DtsSession dtsSession, int dataId, int itemId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlStatement stmt = dtsSession.getConnection().createStatement();
        int deletedCount = 0;
        String query = "DELETE FROM " + this.tableName + " WHERE " + this.dataIdColumnName + "=" + dataId + " AND " + this.itemIdColumnName + "=" + itemId;
        try {
            deletedCount = stmt.executeUpdate(query);
        }
        finally {
            stmt.close();
        }
        return deletedCount;
    }

    public int deleteProperties(DtsSession dtsSession, int dataId) throws Exception {
        Object[] keys = this.propMap.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String key = (String)keys[i];
            int pos = key.indexOf("-");
            int tmpDataId = BcNumberUtil.parseInteger(key.substring(0, pos));
            if (tmpDataId == dataId) {
                this.propMap.remove(key);
            }
            ++i;
        }
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlStatement stmt = dtsSession.getConnection().createStatement();
        int deletedCount = 0;
        String query = "DELETE FROM " + this.tableName + " WHERE " + this.dataIdColumnName + "=" + dataId;
        try {
            deletedCount = stmt.executeUpdate(query);
        }
        finally {
            stmt.close();
        }
        return deletedCount;
    }

    public String getProperty(DtsSession dtsSession, int dataId, int itemId, String defaultValue) throws Exception {
        String key = this.createKey(dataId, itemId);
        String value = null;
        if (this.propMap.keySet().contains(key)) {
            value = this.propMap.get(key);
        } else {
            value = this.getProperty2(dtsSession, dataId, itemId);
            this.propMap.put(key, value);
        }
        if (!BcStringUtil.isEmpty(value)) {
            return value;
        }
        return defaultValue;
    }

    public String getProperty(DtsSession dtsSession, int dataId, int itemId) throws Exception {
        return this.getProperty(dtsSession, dataId, itemId, null);
    }

    public String getProperty2(DtsSession dtsSession, int dataId, int itemId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String resValue = null;
        String query = "SELECT " + this.valueColumnName + " FROM " + this.tableName + " WHERE " + this.dataIdColumnName + "=" + dataId + " AND " + this.itemIdColumnName + "=" + itemId;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                resValue = rs.getString(1);
            }
            rs.close();
        }
        return resValue;
    }

    public ZScfIntProperties getProperties(DtsSession dtsSession, int dataId, List<Integer> itemIdList) throws Exception {
        ZScfIntProperties intProps = new ZScfIntProperties();
        int i = 0;
        while (i < itemIdList.size()) {
            int itemId = itemIdList.get(i);
            String value = this.getProperty(dtsSession, dataId, itemId);
            if (value != null) {
                intProps.put((Integer)itemId, value);
            }
            ++i;
        }
        return intProps;
    }

    public void getProperties(DtsSession dtsSession, int dataId, ZScfIntProperties intProps) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.itemIdColumnName + "," + this.valueColumnName + " FROM " + this.tableName + " WHERE " + this.dataIdColumnName + "=" + dataId;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                int itemId = rs.getInt(1);
                String value = rs.getString(2);
                if (BcStringUtil.isEmpty(value)) continue;
                intProps.put((Integer)itemId, value);
            }
            rs.close();
        }
    }

    public ZScfIntProperties getProperties(DtsSession dtsSession, int dataId) throws Exception {
        ZScfIntProperties intProps = new ZScfIntProperties();
        this.getProperties(dtsSession, dataId, intProps);
        return intProps;
    }

    public List<Integer> getDataIdListByValue(DtsSession dtsSession, int itemId, String value) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.dataIdColumnName + " FROM " + this.tableName + " WHERE " + this.itemIdColumnName + sqlContext.toCondition_number("=", itemId) + " AND " + this.valueColumnName + sqlContext.toCondition_string("=", value);
        BcLogUtil.debug("query=" + query);
        ArrayList<Integer> datIdList = new ArrayList<Integer>();
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                datIdList.add(rs.getInt(1));
            }
            rs.close();
        }
        return datIdList;
    }
}

