/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.rmi.server;

import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.rmi.agent.RmiAgent;
import jp.co.extreme.rmi.agent.RmiAgentContext;
import jp.co.extreme.rmi.common.RmiConnectionEventHandler;
import jp.co.extreme.rmi.common.RmiDataRecieveEventHandler;
import jp.co.extreme.rmi.connector.RmiConnector;
import jp.co.extreme.rmi.connector.RmiNonBlockingConnector;
import jp.co.extreme.rmi.connector.RmiObjectStreamConnector;
import jp.co.extreme.rmi.model.RmiNetConfig;
import jp.co.extreme.rmi.model.RmiPacket;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.rmi.server.RmiServer;

public class RmiRemoteAgent
extends BcLoggableObject
implements RmiAgent,
RmiConnectionEventHandler,
RmiDataRecieveEventHandler {
    protected RmiServer rmixServer;
    protected RmiAgentContext agentContext;
    protected RmiConnector rmixConnector;

    public RmiRemoteAgent(RmiAgentContext agentContext) throws Exception {
        this.agentContext = agentContext;
        agentContext.lastHertBeatTime = agentContext.acceptDatetime = System.currentTimeMillis();
    }

    @Override
    public int getAgentId() {
        return this.hashCode();
    }

    @Override
    public RmiAgentContext getContext() {
        return this.agentContext;
    }

    @Override
    public boolean isOpen() throws Exception {
        return true;
    }

    @Override
    public RmiRespons invoke(RmiRequest rmiReq) throws Exception {
        RmiRespons rmiRes = this.rmixServer.getRmoInvoker().executeRequest(this, rmiReq);
        return rmiRes;
    }

    public void setSocketChannel(SocketChannel socketChannel) throws Exception {
        RmiNetConfig netConfig = new RmiNetConfig();
        RmiNonBlockingConnector nonBlockingConnector = new RmiNonBlockingConnector();
        nonBlockingConnector.setNetConfig(netConfig);
        nonBlockingConnector.setConnectionEventListener(this);
        nonBlockingConnector.setDataRecieveEventHandler(this);
        this.rmixConnector = nonBlockingConnector;
        nonBlockingConnector.connect(socketChannel);
    }

    public void setSocket(Socket socket) throws Exception {
        RmiNetConfig netConfig = new RmiNetConfig();
        RmiObjectStreamConnector objectStreamConnector = new RmiObjectStreamConnector();
        objectStreamConnector.setNetConfig(netConfig);
        objectStreamConnector.setConnectionEventListener(this);
        objectStreamConnector.setDataRecieveEventHandler(this);
        this.rmixConnector = objectStreamConnector;
        objectStreamConnector.setSocket(socket);
    }

    @Override
    public void connected(RmiConnector rmixConnector) throws Exception {
    }

    @Override
    public void disconnected(RmiConnector rmixConnector, Object operator) throws Exception {
        this.rmixServer.removeRemoteAgent(this, "disconnected");
    }

    @Override
    public void dataRecieved(RmiPacket rmixPacket) {
        switch (rmixPacket.getPacketType()) {
            case 11: {
                RmiRequest rmiReq = (RmiRequest)rmixPacket;
                InvokeTask invokeTask = new InvokeTask(rmiReq);
                Future<Object> result = this.rmixServer.executorService.submit(invokeTask);
                break;
            }
            case 13: {
                RmiRequest rmiReq = (RmiRequest)rmixPacket;
                try {
                    this.invoke(rmiReq);
                    break;
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
    }

    public RmiConnector getConnector() {
        return this.rmixConnector;
    }

    public RmiServer getServer() {
        return this.rmixServer;
    }

    public void setServer(RmiServer rmixServer) {
        this.rmixServer = rmixServer;
    }

    public void destruct() throws Exception {
        this.getLogger().info("destructing... : agentId=" + this.getAgentId());
        if (this.rmixConnector != null) {
            try {
                this.rmixConnector.close(this);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            this.rmixConnector = null;
        }
    }

    class InvokeTask
    implements Callable<Object> {
        protected RmiRequest rmiReq;

        public InvokeTask(RmiRequest rmiReq) {
            this.rmiReq = rmiReq;
        }

        @Override
        public Object call() throws Exception {
            RmiRespons rmiRes = RmiRemoteAgent.this.invoke(this.rmiReq);
            RmiRemoteAgent.this.rmixConnector.sendRespons(rmiRes);
            return null;
        }
    }
}

