/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.rmi.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcObjectConvertor;

public class RmiPacket
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -851831487037992150L;
    protected long id = -1L;
    protected byte packetType;
    protected short dataIndex = (short)-1;
    protected Map<Object, Object> dataMap = new HashMap<Object, Object>(4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Object, Object> map = this.dataMap;
        synchronized (map) {
            this.id = -1L;
            this.dataMap.clear();
            this.dataIndex = (short)-1;
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getPacketType() {
        return this.packetType;
    }

    protected void setPacketType(byte packetType) {
        this.packetType = packetType;
    }

    public Map<Object, Object> getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(Map<Object, Object> dataMap) {
        this.dataMap = dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putData(Object key, Object value) {
        Map<Object, Object> map = this.dataMap;
        synchronized (map) {
            this.dataMap.put(key, value);
        }
    }

    public void putData(Object key, int value) {
        this.dataMap.put(key, new Integer(value));
    }

    public void putData(Object key, boolean value) {
        this.dataMap.put(key, new Boolean(value));
    }

    public void putDataClassNameKey(Object value) {
        this.dataMap.put(value.getClass().getName(), value);
    }

    public void addData(Object value) throws Exception {
        this.dataIndex = (short)(this.dataIndex + 1);
        this.putData(this.createKey(this.dataIndex), value);
    }

    protected Object createKey(int index) throws Exception {
        return new Integer(index);
    }

    public void removeData(Object key) {
        this.dataMap.remove(key);
    }

    public Object getObject(Object key) {
        return this.dataMap.get(key);
    }

    public Object getObjectByClass(Class clazz) {
        return this.dataMap.get(clazz.getName());
    }

    public String getDataAsString(Object key) throws Exception {
        Object value = this.dataMap.get(key);
        if (value == null) {
            return null;
        }
        value = BcObjectConvertor.getInstance().convert(value, String.class, null, null);
        return (String)value;
    }

    public Long getDataAsLong(Object key) {
        return (Long)this.dataMap.get(key);
    }

    public Integer getDataAsInteger(Object key) {
        return (Integer)this.dataMap.get(key);
    }

    public Short getDataAsShort(Object key) {
        return (Short)this.dataMap.get(key);
    }

    public Number getDataAsNumber(Object key) {
        return (Number)this.dataMap.get(key);
    }

    public boolean getDataAsBoolean(Object key) {
        Object value = this.dataMap.get(key);
        return (Boolean)value;
    }

    public Calendar getDataAsCalendar(Object key) {
        return (Calendar)this.dataMap.get(key);
    }

    public byte[] getDataAsByteArray(Object key) {
        return (byte[])this.dataMap.get(key);
    }

    public Object getData() throws Exception {
        this.dataIndex = (short)(this.dataIndex + 1);
        return this.getObject(this.createKey(this.dataIndex));
    }

    public String getDataAsString() throws Exception {
        this.dataIndex = (short)(this.dataIndex + 1);
        return this.getDataAsString(this.createKey(this.dataIndex));
    }

    public Long getDataAsLong() throws Exception {
        this.dataIndex = (short)(this.dataIndex + 1);
        return this.getDataAsLong(this.createKey(this.dataIndex));
    }

    public Integer getDataAsInteger() throws Exception {
        this.dataIndex = (short)(this.dataIndex + 1);
        return this.getDataAsInteger(this.createKey(this.dataIndex));
    }

    public Short getDataAsShort() throws Exception {
        this.dataIndex = (short)(this.dataIndex + 1);
        return this.getDataAsShort(this.createKey(this.dataIndex));
    }

    public Number getDataAsNumber() throws Exception {
        this.dataIndex = (short)(this.dataIndex + 1);
        return this.getDataAsNumber(this.createKey(this.dataIndex));
    }

    public boolean getDataAsBoolean() throws Exception {
        this.dataIndex = (short)(this.dataIndex + 1);
        return this.getDataAsBoolean(this.createKey(this.dataIndex));
    }

    public Calendar getDataAsCalendar() throws Exception {
        this.dataIndex = (short)(this.dataIndex + 1);
        return this.getDataAsCalendar(this.createKey(this.dataIndex));
    }

    public byte[] getDataAsByteArray() throws Exception {
        this.dataIndex = (short)(this.dataIndex + 1);
        return this.getDataAsByteArray(this.createKey(this.dataIndex));
    }

    public void setDataIndex(int dataIndex) {
        this.dataIndex = (short)dataIndex;
    }

    public boolean hasMoreData() throws Exception {
        Object value = this.getObject(this.createKey(this.dataIndex + 1));
        return value != null;
    }

    public Object clone() throws CloneNotSupportedException {
        Map<Object, Object> map = this.dataMap;
        synchronized (map) {
            try {
                RmiPacket obj = (RmiPacket)super.clone();
                obj.dataMap = new HashMap<Object, Object>(2);
                BcCollectionUtil.copy(this.dataMap, obj.dataMap, true);
                return obj;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public String toString() {
        String str = " dataMap.size()=" + this.dataMap.size() + " dataIndex=" + this.dataIndex;
        return str;
    }
}

