/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import jp.co.extreme.base.log.BcLoggableObject;
import opennlp.tools.util.Span;

public class OpenNlpUtil
extends BcLoggableObject {
    public static OpenNlpUtil getInstance() {
        return SingletonHolder.instance;
    }

    public static String toString(Span span, String[] sentenceArray) {
        StringBuilder sb = new StringBuilder();
        int i = span.getStart();
        while (i < span.getEnd()) {
            sb.append(sentenceArray[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String createInfo(Span span, String[] sentenceArray) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("type: " + span.getType());
        sb.append(", words: " + OpenNlpUtil.toString(span, sentenceArray));
        return sb.toString();
    }

    private static final class SingletonHolder {
        private static final OpenNlpUtil instance = new OpenNlpUtil();

        private SingletonHolder() {
        }
    }
}

