/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.web;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcCloneUtil;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.base.yaml.BcYamlUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.mail.BcMailUtil;
import jp.co.extreme.module.htsv.dao.HtsvSitePropertyDAO;
import jp.co.extreme.module.wbfw.common.WbfSiteContext;
import jp.co.extreme.module.wbfw.common.WbfwResourceHolder;
import jp.co.extreme.module.wbfw.common.WbfwWebModule;
import jp.co.extreme.module.wbfw.container.WbfwCmcManager;
import jp.co.extreme.module.wbfw.container.WbfwContainer;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.scf.common.ScfAbstractModule;
import jp.co.extreme.scf.server.ScfServerContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XwebWebSetup
extends BcLoggableObject {
    public void setup() throws Exception {
        WbfwCmcManager cmcManager;
        this.getLogger().info("XwebWebSetup:strat...");
        AfbApplication application = AfbApplication.getInstance();
        WbfwContainer webContainer = new WbfwContainer();
        this.setup1(application, webContainer);
        WbfwResourceHolder.getInstance().webContainer = webContainer;
        webContainer.startService();
        WbfwResourceHolder.getInstance().cmcManager = cmcManager = new WbfwCmcManager();
        ScfServerContainer serverContainer = ScfServerContainer.getInstance();
        int i = 0;
        while (i < serverContainer.tableModel.getRowCount()) {
            ScfAbstractModule module = (ScfAbstractModule)serverContainer.tableModel.getValueAt(i, 0);
            if (WbfwWebModule.class.isAssignableFrom(module.getClass())) {
                WbfwWebModule webModule = (WbfwWebModule)((Object)module);
                webModule.setupWebModule();
            }
            ++i;
        }
        this.setupSiteContext();
    }

    protected void setup1(AfbApplication application, WbfwContainer webContainer) throws Exception {
        WbfSiteContext siteContext;
        String webCofigPath = application.toReal("${APP}config/web.xml");
        this.getLogger().debug("webCofigPath=" + webCofigPath);
        File file = new File(webCofigPath);
        BcFileUtil.notEexistsException(file);
        Document webConfigDom = BcXmlUtil.createDocument(file);
        Node baseNode = BcXmlUtil.getNode(webConfigDom, "webContainer");
        if (baseNode == null) {
            throw new Exception("not found node 'webContainer'.");
        }
        webContainer.siteContextDefault = siteContext = new WbfSiteContext();
        String tmpStr = BcXmlUtil.getTextValue(baseNode, "sessionLifeSpan");
        siteContext.sessionLifeSpan = BcNumberUtil.parseInt(tmpStr, -1);
        tmpStr = BcXmlUtil.getTextValue(baseNode, "sessionLifeCheckInterval");
        siteContext.sessionLifeCheckInterval = BcNumberUtil.parseInt(tmpStr, -1);
        if (siteContext.sessionLifeCheckInterval <= 0) {
            throw new Exception("sessionLifeCheckInterval=" + siteContext.sessionLifeCheckInterval);
        }
    }

    protected void setupSiteContext() throws Exception {
        File[] files;
        AfbApplication application = AfbApplication.getInstance();
        WbfwContainer webContainer = WbfwResourceHolder.getInstance().webContainer;
        String dirStr = application.toReal("${APP}config/site");
        this.getLogger().info("setupSite:dirStr=" + dirStr);
        File dir = new File(dirStr);
        BcFileUtil.notEexistsException(dir);
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (BcYamlUtil.isYamlFile(file)) {
                this.parseSiteConfig(webContainer, file);
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void parseSiteConfig(WbfwContainer webContainer, File file) throws Exception {
        this.getLogger().info("");
        this.getLogger().info("file=" + file.getPath());
        Map rootMap = (Map)BcYamlUtil.load(file);
        WbfSiteContext siteContext = BcCloneUtil.createClone(webContainer.siteContextDefault);
        siteContext.siteId = (Integer)rootMap.get(WbxConstants.SitePropertyKey.siteId.key);
        siteContext.dataSourceId = 1;
        this.getLogger().info("siteId=" + siteContext.siteId + " datasourceId=" + siteContext.dataSourceId);
        List resourcePathList = (List)rootMap.get("resourcePath");
        for (String resourcePath : resourcePathList) {
            File file2 = new File(AfbApplication.getInstance().toReal(resourcePath));
            siteContext.resourceDirList.add(file2);
        }
        if (webContainer.siteIdMap.containsKey(siteContext.siteId)) {
            String msg = "\u30b5\u30a4\u30c8ID\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002siteId=" + siteContext.siteId;
            throw new Exception(msg);
        }
        webContainer.siteIdMap.put(siteContext.siteId, siteContext);
        Object serverTmp = rootMap.get("server");
        ArrayList<String> serverList = new ArrayList<String>();
        if (serverTmp instanceof String) {
            serverList.add((String)serverTmp);
        } else if (serverTmp instanceof List) {
            List list = (List)serverTmp;
            serverList.addAll(list);
        }
        for (String string : serverList) {
            this.getLogger().info("server=" + string);
            if (webContainer.serverNameMap.containsKey(string)) {
                this.getLogger().warning("\u4e0a\u66f8\u304d\u3057\u307e\u3059\u3002server=" + string);
            }
            webContainer.serverNameMap.put(string, siteContext);
        }
        Throwable throwable = null;
        Iterator iterator = null;
        try (DtsSession dtsSession = DtsSessionFactoryManegaer.getInstance().createSession(Wbs1Constants.getDatasourceName(), this);){
            siteContext.propertyMap = HtsvSitePropertyDAO.getInstance().getMap(dtsSession, siteContext.siteId);
        }
        catch (Throwable throwable2) {
            void var8_16;
            if (throwable == null) {
                Throwable throwable3 = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw var8_16;
        }
        this.setPropertyMap(siteContext, siteContext.propertyMap);
    }

    public void setPropertyMap(WbfSiteContext siteContext, Map<String, String> propertyMap) throws Exception {
        siteContext.propertyMap = propertyMap;
        siteContext.smptProperties = new Properties();
        this.copy(propertyMap, siteContext.smptProperties, BcMailUtil.MailProperty.mail_smtp_host.key);
        this.copy(propertyMap, siteContext.smptProperties, BcMailUtil.MailProperty.mail_smtp_port.key);
        this.copy(propertyMap, siteContext.smptProperties, BcMailUtil.MailProperty.mail_smtp_auth.key);
        this.copy(propertyMap, siteContext.smptProperties, BcMailUtil.MailProperty.mail_smtp_starttls_enable.key);
        this.copy(propertyMap, siteContext.smptProperties, BcMailUtil.MailProperty.mail_smtp_ssl_protocols.key);
        this.copy(propertyMap, siteContext.smptProperties, BcMailUtil.MailProperty.mail_smtp_ssl_trust.key);
        this.copy(propertyMap, siteContext.smptProperties, BcMailUtil.MailProperty.mail_smtp_timeout.key);
        siteContext.mailSenderUserName = propertyMap.get(WbxConstants.SitePropertyKey.mailSenderUserName.key);
        siteContext.mailSenderPassword = propertyMap.get(WbxConstants.SitePropertyKey.mailSenderPassword.key);
        siteContext.mailSenderAddress = propertyMap.get(WbxConstants.SitePropertyKey.mailSenderAddress.key);
        siteContext.mailSenderPersonal = propertyMap.get(WbxConstants.SitePropertyKey.mailSenderPersonal.key);
        siteContext.mailDestination = propertyMap.get(WbxConstants.SitePropertyKey.mailDestination.key);
        siteContext.mailSubjectPrefix = propertyMap.get(WbxConstants.SitePropertyKey.mailSubjectPrefix.key);
        siteContext.siteName = propertyMap.get(WbxConstants.SitePropertyKey.siteName.key);
        siteContext.catchphrase = propertyMap.get(WbxConstants.SitePropertyKey.catchphrase.key);
        siteContext.copyright = propertyMap.get(WbxConstants.SitePropertyKey.copyright.key);
        siteContext.homePath = propertyMap.get(WbxConstants.SitePropertyKey.homePath.key);
        this.getLogger().info("siteName=" + siteContext.siteName + " copyright=" + siteContext.copyright + " homePath=" + siteContext.homePath);
        siteContext.theme = propertyMap.get(WbxConstants.SitePropertyKey.theme.key);
    }

    public void copy(Map map1, Map map2, Object key) throws Exception {
        Object value = map1.get(key);
        if (value != null) {
            map2.put(key, value);
        } else {
            this.getLogger().warning("key=" + key + " value=" + value);
        }
    }
}

