/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.css.common.CssBuiler;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.module.xweb.common.FontawesomeUtil;

public class XwebIconManager
extends BcLoggableObject {
    private HtmlBuilder htmlBuilder;

    public XwebIconManager() {
        this.setHtmlBuilder(HtmlBuilder.getInstance());
    }

    public static XwebIconManager getInstance() {
        return SingletonHolder.instance;
    }

    public void setHtmlBuilder(HtmlBuilder htmlBuilder) {
        this.htmlBuilder = htmlBuilder;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.htmlBuilder;
    }

    public static String createTag(WebIcon icon, String style) throws Exception {
        switch (icon) {
            case angleLeft: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_angle_left, style);
            }
            case angleRight: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_angle_right, style);
            }
            case address: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_location_dot, style);
            }
            case attendanceSchedule: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_calendar_check, style);
            }
            case bars: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_bars, style);
            }
            case clock: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_clock, style);
            }
            case coins: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_coins, style);
            }
            case coupon: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_ticket, style);
            }
            case database: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_database, style);
            }
            case emailAddress: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_envelope, style);
            }
            case female: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_person_dress, style);
            }
            case femaleSymbol: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_venus, style);
            }
            case home: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_house, style);
            }
            case login: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_right_to_bracket, style);
            }
            case logout: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_right_from_bracket, style);
            }
            case mail: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_envelope, style);
            }
            case male: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_person, style);
            }
            case maleSymbol: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_mars_stroke_up, style);
            }
            case message: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_message, style);
            }
            case myPage: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_circle_user, style);
            }
            case nearestStation: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_train_subway, style);
            }
            case operatingOrganization: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_people_group, style);
            }
            case passwordForgot: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_file_circle_question, style);
            }
            case personalIdentification: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_person_dress, style);
            }
            case personalInformation: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_user_shield, style);
            }
            case privacyPolicy: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_user_shield, style);
            }
            case search: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_magnifying_glass, style);
            }
            case square: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_square, style);
            }
            case table: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_table_list, style);
            }
            case termsOfService: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_file_circle_check, style);
            }
            case upload: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_upload, style);
            }
            case userAccount: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_key, style);
            }
            case userRegistration: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_user_pen, style);
            }
            case dummy: {
                return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_circle_dot, style);
            }
        }
        return FontawesomeUtil.createTag(FontawesomeUtil.FaIcon.fa_bug, style);
    }

    public static String createTag(WebIcon icon) throws Exception {
        String style = XwebIconManager.createCss(null);
        return XwebIconManager.createTag(icon, style);
    }

    public static String createCss(String fontSize) throws Exception {
        CssBuiler cssBuiler = new CssBuiler();
        cssBuiler.color("var(--icon-color)");
        if (!BcStringUtil.isEmpty(fontSize)) {
            cssBuiler.font_size(fontSize);
        }
        return cssBuiler.build();
    }

    private static final class SingletonHolder {
        private static final XwebIconManager instance = new XwebIconManager();

        private SingletonHolder() {
        }
    }

    public static enum WebIcon {
        angleLeft,
        angleRight,
        address,
        attendanceSchedule,
        bars,
        clock,
        coins,
        coupon,
        database,
        emailAddress,
        female,
        femaleSymbol,
        home,
        login,
        logout,
        mail,
        male,
        maleSymbol,
        message,
        myPage,
        nearestStation,
        operatingOrganization,
        passwordForgot,
        personalIdentification,
        personalInformation,
        privacyPolicy,
        search,
        square,
        table,
        termsOfService,
        upload,
        userAccount,
        userRegistration,
        dummy;

    }
}

