/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.util.Collection;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;

public class HtmlUlCreator
extends BcLoggableObject {
    private HtmlBuilder htmlBuilder;
    public boolean idOrdered;
    public String ulClass;

    public HtmlUlCreator() {
        this.setHtmlBuilder(HtmlBuilder.getInstance());
    }

    public void setHtmlBuilder(HtmlBuilder htmlBuilder) {
        this.htmlBuilder = htmlBuilder;
    }

    public StringBuilder create(Collection<? extends CharSequence> charSequenceCollection) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ul_start());
        int index = 0;
        for (CharSequence charSequence : charSequenceCollection) {
            if (index > 0) {
                sb.append(this.htmlBuilder.span(null, String.valueOf(BcStringUtil.SPACE_STR) + BcStringUtil.SPACE_STR, true));
            }
            sb.append((CharSequence)this.create_L2(index, charSequence));
            ++index;
        }
        sb.append(this.ul_end());
        return sb;
    }

    protected StringBuilder create_L2(int index, CharSequence charSequence) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.htmlBuilder.li_start(ExtwCssUtil.ExtwClass.extw_inline_block.className, null));
        sb.append(charSequence);
        sb.append(this.htmlBuilder.li_end());
        return sb;
    }

    protected String ul_start() throws Exception {
        if (this.idOrdered) {
            return this.htmlBuilder.ol_start(this.ulClass, null);
        }
        return this.htmlBuilder.ul_start(this.ulClass, null);
    }

    protected String ul_end() throws Exception {
        if (this.idOrdered) {
            return this.htmlBuilder.ol_end();
        }
        return this.htmlBuilder.ul_end();
    }
}

