/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xsod.common.XsodWords;
import jp.co.extreme.module.xsod.fx.XsodController;
import jp.co.extreme.module.xsod.fx.XsodDesktop;
import jp.co.extreme.module.xsod.fx.XsodOrderRowPane;
import jp.co.extreme.module.xsod.fx.XsodUiFactory;
import jp.co.extreme.module.xsod.model.XsodOrder;

public class XsodOrderPlanFixPane
extends FxBorderPane {
    public static final int MODE_orderPlanFix = 1;
    public static final int MODE_orderHistory = 2;
    FxBorderPane borderPane = new FxBorderPane();
    Pane listBasePane = new Pane();
    HBox topBox = XsodUiFactory.getInstance().createHBox();
    HBox bottomBox = XsodUiFactory.getInstance().createHBox();
    Button fixButton;
    Button cancelButton;
    int mode;
    List<XsodOrderRowPane> orderRowPaneList;

    public XsodOrderPlanFixPane(int mode) throws Exception {
        this.fixButton = XsodUiFactory.getInstance().createButton(XsodWords.getInstance().\u306f\u3044.toString());
        this.cancelButton = XsodUiFactory.getInstance().createButton(XsodWords.getInstance().\u3044\u3044\u3048.toString());
        this.orderRowPaneList = new ArrayList<XsodOrderRowPane>();
        this.mode = mode;
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        Text titleText = new Text();
        titleText.setFill((Paint)Color.BLACK);
        titleText.setStrokeWidth(1.5);
        titleText.setStroke((Paint)Color.BLACK);
        titleText.setFont(XsodUiFactory.getInstance().defaultFont);
        titleText.setText(XsodWords.getInstance().\u6b21\u306e\u6ce8\u6587\u3092\u78ba\u5b9a\u3057\u307e\u3059\u304b.toString());
        this.topBox.setAlignment(Pos.CENTER);
        this.topBox.getChildren().addAll((Object[])new Node[]{titleText});
        this.borderPane.setTop((Node)this.topBox);
        this.bottomBox.setAlignment(Pos.CENTER);
        this.borderPane.setBottom((Node)this.bottomBox);
        this.fixButton.setOnAction(this.actionEventHandler);
        this.bottomBox.getChildren().addAll((Object[])new Node[]{this.fixButton});
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.bottomBox.getChildren().addAll((Object[])new Node[]{this.cancelButton});
        this.borderPane.setCenter((Node)this.listBasePane);
        StackPane baseStackPane = XsodUiFactory.getInstance().createBackgrondNode((Node)this.borderPane, Color.AZURE);
        this.setCenter((Node)baseStackPane);
    }

    public void setData(Collection<XsodOrder> orderCollection) throws Exception {
        this.orderRowPaneList.clear();
        for (XsodOrder order : orderCollection) {
            XsodOrderRowPane orderRowPane = new XsodOrderRowPane(2);
            orderRowPane.setData(order);
            this.orderRowPaneList.add(orderRowPane);
        }
        this.dispOrderList();
    }

    protected void dispOrderList() throws Exception {
        this.listBasePane.getChildren().clear();
        double x = 400.0;
        double rowSpace = 8.0;
        int i = 0;
        while (i < this.orderRowPaneList.size()) {
            XsodOrderRowPane orderRowPane = this.orderRowPaneList.get(i);
            double y = (double)i * (XsodUiFactory.getInstance().orderPlanRowHeight + rowSpace);
            FxUtil.setLocation(this.listBasePane, (Region)orderRowPane, x, y, 200.0, XsodUiFactory.getInstance().orderPlanRowHeight);
            ++i;
        }
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.fixButton) {
            ArrayList<XsodOrder> orderList = new ArrayList<XsodOrder>();
            int i = 0;
            while (i < this.orderRowPaneList.size()) {
                XsodOrderRowPane orderRowPane = this.orderRowPaneList.get(i);
                orderList.add(orderRowPane.order);
                ++i;
            }
            XsodController.getInstance().addOrderFix(orderList);
            XsodDesktop.getInstance().customerPane.removePopup();
        } else if (ev.getSource() == this.cancelButton) {
            XsodDesktop.getInstance().customerPane.removePopup();
        }
    }
}

