/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.skin.FxCssUtil;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xsod.common.XsodUtil;
import jp.co.extreme.module.xsod.fx.XsodCurrentOrderListPane;
import jp.co.extreme.module.xsod.fx.XsodKitchenTopPane;
import jp.co.extreme.module.xsod.fx.XsodUiFactory;
import jp.co.extreme.module.xsod.model.XsodCondition;
import jp.co.extreme.module.xsod.model.XsodMenuData;
import jp.co.extreme.module.xsod.model.XsodOrderSession;
import jp.co.extreme.module.xsod.stub.XsodOrderStub;

public class XsodKitchenPane
extends FxBorderPane {
    StackPane stackPane = new StackPane();
    Pane imagePane = new Pane();
    BorderPane borderPane1 = new BorderPane();
    BorderPane borderPane2 = new BorderPane();
    XsodKitchenTopPane kitchenTopPane = new XsodKitchenTopPane();
    XsodCurrentOrderListPane currentOrderListPane = new XsodCurrentOrderListPane();
    XsodMenuData menuData;
    Timer timer;

    public XsodKitchenPane() throws Exception {
        this.kitchenTopPane.setPrefHeight(60.0);
        this.borderPane1.setBottom((Node)this.kitchenTopPane);
        this.stackPane.getChildren().add((Object)this.imagePane);
        this.setBackground();
        this.stackPane.getChildren().add((Object)this.borderPane1);
        this.setCenter((Node)this.stackPane);
        this.borderPane2.setCenter((Node)this.currentOrderListPane);
        FxUtil.setInsets(this.borderPane2, 10.0);
        this.setContentNode((Node)this.borderPane2);
    }

    public void setContentNode(Node contentsNode) throws Exception {
        this.borderPane1.setCenter(contentsNode);
        FxUtil.setInsets(this.borderPane1, XsodUiFactory.getInstance().categorySpacing);
    }

    private void setBackground() throws Exception {
        String filePath = "Y:/ext_develop/ews_ext_g32/92_11_11_runtime/rydeen_sa/resource/image/background_1.jpg";
        String style = FxCssUtil.createBackgroundImage(new File(filePath).toURI(), 0.3);
        this.imagePane.setStyle(style);
    }

    private void refreshOrder() throws Exception {
        BcLogUtil.debug("refreshOrder!!!!");
        XsodCondition condition = new XsodCondition();
        short[] orderStatuses = new short[]{2, 3, 4, 5};
        condition.orderStatuses = orderStatuses;
        Object[] res = XsodOrderStub.getInstance().getCurrentOrderList(condition);
        List orderList = (List)res[0];
        List orderSessionList = (List)res[1];
        Map<Integer, XsodOrderSession> orderSessionMap = XsodUtil.toOrderSessionMap(orderSessionList);
        this.currentOrderListPane.setOrderList(orderList, orderSessionMap);
    }

    class RefreshTask
    extends TimerTask {
        @Override
        public void run() {
            try {
                XsodKitchenPane.this.refreshOrder();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }
}

