/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.util.EtcLockManger;
import jp.co.extreme.module.xfil.common.HashtagUtil;
import jp.co.extreme.module.xfil.common.XfilTagUtil;
import jp.co.extreme.module.xfil.dao.XfilUriEntityDAO;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.server.XfilServerUtil;
import jp.co.extreme.nlp.NlpNoun;
import jp.co.extreme.nlp.NlpNounFinderEN;
import jp.co.extreme.nlp.NlpNounFinderJA;
import jp.co.extreme.task.TskAbstractCallable2;

public class XfilTagCreateTask
extends TskAbstractCallable2 {
    public Future future;
    public DtsSession dtsSessionWk;
    public XfilUriEntityDAO uriEntityDao;
    NlpNounFinderJA nounFinderJA;
    NlpNounFinderEN nounFinderEN;

    public Object taskProcess() throws Exception {
        long exceptEntityId = -1L;
        while (true) {
            XfilUriEntity uriEntity;
            if ((uriEntity = (XfilUriEntity)this.uriEntityDao.getForTag(this.dtsSessionWk, -1L, exceptEntityId)) == null) {
                Thread.sleep(3000L);
                exceptEntityId = -1L;
                continue;
            }
            XfilUriEntity preEntity = EtcLockManger.getInstance().check(uriEntity, uriEntity.id);
            if (preEntity == null) {
                block9: {
                    try {
                        try {
                            this.createTag(uriEntity);
                        }
                        catch (Exception ex) {
                            this.getLogger().error(ex);
                            EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                        throw throwable;
                    }
                    EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                }
                exceptEntityId = -1L;
            } else {
                exceptEntityId = preEntity.id;
            }
            this.getLogger().info(null);
        }
    }

    protected void createTag(XfilUriEntity uriEntity) throws Exception {
        this.getLogger().info("createTag:uriEntity.name=" + uriEntity.name);
        this.nounFinderJA = XfilServerUtil.getInstance().getNounFinderJA();
        this.nounFinderEN = XfilServerUtil.getInstance().getNounFinderEN();
        ArrayList<NlpNoun> elementList1 = new ArrayList<NlpNoun>();
        List<NlpNoun> elementList2 = this.nounFinderJA.find(uriEntity.name);
        elementList1.addAll(elementList2);
        elementList2 = this.nounFinderEN.find(uriEntity.name);
        elementList1.addAll(elementList2);
        ArrayList<String> tagList = new ArrayList<String>();
        int i = 0;
        while (i < elementList1.size()) {
            NlpNoun noun = (NlpNoun)elementList1.get(i);
            String tag = noun.text.replace(BcUnicode.space.string, BcUnicode.horizontalBar.string);
            tag = HashtagUtil.getInstance().removeNotAllowedCharacter(tag);
            if (!BcStringUtil.isEmpty(tag)) {
                tagList.add(tag);
            }
            ++i;
        }
        uriEntity.tag = BcCollectionUtil.isEmpty(tagList) ? XfilTagUtil.EMPTY : XfilTagUtil.toPersistenceString(tagList);
        boolean fileExists = XfilServerUtil.getInstance().checkFileExists(uriEntity);
        this.uriEntityDao.putEntity(this.dtsSessionWk, uriEntity);
        this.dtsSessionWk.commit();
    }
}

