/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.common;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.net.BcNetUtil;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCompareUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.module.xfil.common.FfprobeUtil;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.model.MovieInfo;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.model.XfilUriEntityWrap;
import jp.co.extreme.sql.SqlConditionParser;
import jp.co.extreme.sql.context.SqlContext;

public final class XfilUtil {
    public int capturingWidth;
    public int capturingHeight;
    static final int fileUnit = 100;
    static final int FolderLevel = 2;

    private XfilUtil() {
    }

    public static String toSchemaName(int schemeId) throws Exception {
        if (schemeId == XfilConstants.Scheme.file.id) {
            return BcNetUtil.Protocol.file.name();
        }
        if (schemeId == XfilConstants.Scheme.http.id) {
            return BcNetUtil.Protocol.http.name();
        }
        throw new Exception("\u30b9\u30ad\u30fc\u30e0ID " + schemeId + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
    }

    public static String createInfo(Path path) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("path=" + path.toFile().getPath());
        sb.append(BcRuntimeUtil.lineSeparator);
        sb.append("isDirectory=" + Files.isDirectory(path, new LinkOption[0]));
        sb.append(BcRuntimeUtil.lineSeparator);
        sb.append("isReadable=" + Files.isReadable(path));
        sb.append(BcRuntimeUtil.lineSeparator);
        sb.append("isRegularFile=" + Files.isRegularFile(path, new LinkOption[0]));
        return sb.toString();
    }

    public static void setAttributes(Path path, XfilUriEntity uriEntity) throws Exception {
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        uriEntity.entityType = Files.isDirectory(path, new LinkOption[0]) ? Short.valueOf(XfilConstants.FileType.directory.id) : Short.valueOf(XfilConstants.FileType.file.id);
        if (Files.isReadable(path)) {
            uriEntity.size = basicFileAttributes.size();
        }
        uriEntity.creationDatetime = BcTimeUtil.toCalendar(basicFileAttributes.creationTime().toMillis());
        uriEntity.lastModifiedDatetime = BcTimeUtil.toCalendar(basicFileAttributes.lastModifiedTime().toMillis());
        uriEntity.lastAccessDatetime = BcTimeUtil.toCalendar(basicFileAttributes.lastAccessTime().toMillis());
        uriEntity.hidden = Files.isHidden(path);
        uriEntity.symbolicLink = Files.isSymbolicLink(path);
        uriEntity.executable = Files.isExecutable(path);
        uriEntity.readable = Files.isReadable(path);
        uriEntity.writable = Files.isWritable(path);
        FileOwnerAttributeView fileOwnerAttributeView = Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]);
        UserPrincipal userPrincipal = fileOwnerAttributeView.getOwner();
        uriEntity.owner = userPrincipal.getName();
        if (BcRuntimeUtil.getOsType() != BcRuntimeUtil.OsType.Windows) {
            Set<PosixFilePermission> posixFilePermissionSet = Files.getPosixFilePermissions(path, new LinkOption[0]);
            uriEntity.posixPermission = PosixFilePermissions.toString(posixFilePermissionSet);
        }
    }

    public static void toUriEntity(Path path, XfilUriEntity uriEntity, boolean setAttributes) throws Exception {
        uriEntity.schemeId = XfilConstants.Scheme.file.id;
        if (path.getParent() == null) {
            uriEntity.directory = path.toString();
            String[] res = BcFileUtil.separatePath(uriEntity.directory);
            uriEntity.drive = res[0];
        } else {
            uriEntity.directory = BcFileUtil.reformPath(path.getParent().toString());
            String[] res = BcFileUtil.separatePath(uriEntity.directory);
            uriEntity.drive = res[0];
        }
        uriEntity.name = null;
        uriEntity.extention = null;
        if (path.getFileName() != null) {
            uriEntity.name = path.getFileName().toString();
            if (!Files.isDirectory(path, new LinkOption[0])) {
                uriEntity.extention = BcFileUtil.getExtention(uriEntity.name);
            }
        }
        if (setAttributes) {
            XfilUtil.setAttributes(path, uriEntity);
        }
    }

    public static XfilUriEntity toUriEntity(Path path, boolean setAttributes) throws Exception {
        XfilUriEntity uriEntity = new XfilUriEntity();
        XfilUtil.toUriEntity(path, uriEntity, setAttributes);
        return uriEntity;
    }

    public static void toUriEntity(XfilUriEntity uriEntity, URI uri, boolean setAttributes) throws Exception {
        if (BcNetUtil.isFile(uri)) {
            File file = new File(uri);
            XfilUtil.toUriEntity(file.toPath(), uriEntity, setAttributes);
        } else if (BcNetUtil.isHttp(uri)) {
            uriEntity.schemeId = XfilConstants.Scheme.http.id;
            uriEntity.name = BcNetUtil.getFileName(uri);
            int fileNameLength = BcStringUtil.length(uriEntity.name);
            int pathLength = uri.toString().length();
            uriEntity.directory = uri.toString().substring(0, pathLength - fileNameLength);
            uriEntity.directory = BcStringUtil.replace((CharSequence)uriEntity.directory, String.valueOf(BcNetUtil.Protocol.http.name()) + BcNetUtil.PROTOCOL_suffix, "").toString();
            uriEntity.extention = BcFileUtil.getExtention(uriEntity.name);
        }
    }

    public static XfilUriEntity toUriEntity(URI uri, boolean setAttributes) throws Exception {
        XfilUriEntity uriEntity = new XfilUriEntity();
        XfilUtil.toUriEntity(uriEntity, uri, setAttributes);
        return uriEntity;
    }

    public static URI toUri(XfilUriEntity uriEntity) throws Exception {
        URI uri = null;
        if (uriEntity.schemeId == XfilConstants.Scheme.file.id) {
            StringBuilder filePath = new StringBuilder();
            filePath.append(BcFileUtil.appendEndSlash(uriEntity.directory));
            BcStringUtil.appendCaseOfNotEmpty(filePath, uriEntity.name);
            File file = new File(filePath.toString());
            uri = file.toURI();
        } else if (uriEntity.schemeId == XfilConstants.Scheme.http.id) {
            URL url = XfilUtil.toUrl(uriEntity);
            uri = url.toURI();
        } else {
            String scheme = XfilUtil.toSchemaName(uriEntity.schemeId);
            String userInfo = null;
            String host = null;
            int port = 0;
            String path = uriEntity.directory;
            String query = null;
            String fragment = null;
            uri = new URI(scheme, userInfo, host, port, path, query, fragment);
        }
        return uri;
    }

    public static URL toUrl(Object source) throws Exception {
        URL url = null;
        if (source instanceof URL) {
            url = (URL)source;
        } else if (source instanceof XfilUriEntity) {
            XfilUriEntity uriEntity = (XfilUriEntity)source;
            url = XfilUtil.toUrl(uriEntity);
        }
        return url;
    }

    public static File toFile(XfilUriEntity uriEntity) throws Exception {
        URI uri = XfilUtil.toUri(uriEntity);
        File file = new File(uri);
        return file;
    }

    public static List<XfilUriEntity> createUriEntityList(Collection<File> fileCollection, boolean setAttributes) throws Exception {
        ArrayList<XfilUriEntity> uriEntityList = new ArrayList<XfilUriEntity>();
        for (File file : fileCollection) {
            XfilUriEntity uriEntity = XfilUtil.toUriEntity(file.toPath(), setAttributes);
            uriEntityList.add(uriEntity);
        }
        return uriEntityList;
    }

    public static List<XfilUriEntity> createUriEntityListByPath(Collection<String> filePathCollection, boolean setAttributes) throws Exception {
        ArrayList<File> fileList = new ArrayList<File>();
        for (String filePath : filePathCollection) {
            fileList.add(new File(filePath));
        }
        return XfilUtil.createUriEntityList(fileList, setAttributes);
    }

    public static List<XfilUriEntity> createUriEntityList(File dirFile) throws Exception {
        ArrayList<File> dirList = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        File[] files = dirFile.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    dirList.add(file);
                } else {
                    fileList.add(file);
                }
                ++i;
            }
        }
        dirList.addAll(fileList);
        return XfilUtil.createUriEntityList(dirList, true);
    }

    public static List<XfilUriEntity> createUriEntityList(URI uri) throws Exception {
        String urlStr2 = URLDecoder.decode(uri.toString(), "UTF-8");
        Path path = BcNetUtil.uriToPath(urlStr2);
        File file = path.toFile();
        return XfilUtil.createUriEntityList(file);
    }

    public static XfilUriEntityWrap createUriEntityWrap(URI uri, boolean setAttributes) throws Exception {
        BcLogUtil.debug("createUriEntityWrap:uri=" + uri);
        XfilUriEntityWrap uriEntityWrap = new XfilUriEntityWrap();
        uriEntityWrap.uriEntity = XfilUtil.toUriEntity(uri, setAttributes);
        uriEntityWrap.uri = uri;
        uriEntityWrap.uriStr = uriEntityWrap.uri.toString();
        return uriEntityWrap;
    }

    public static List<XfilUriEntityWrap> createUriEntityWrapList(URI uri) throws Exception {
        ArrayList<XfilUriEntityWrap> uriEntityWrapList = new ArrayList<XfilUriEntityWrap>();
        List<XfilUriEntity> uriEntityList = XfilUtil.createUriEntityList(uri);
        for (XfilUriEntity uriEntity : uriEntityList) {
            XfilUriEntityWrap uriEntityWrap = new XfilUriEntityWrap();
            uriEntityWrap.uriEntity = uriEntity;
            uriEntityWrap.uri = XfilUtil.toUri(uriEntity);
            uriEntityWrap.uriStr = uriEntityWrap.uri.toString();
            uriEntityWrapList.add(uriEntityWrap);
        }
        return uriEntityWrapList;
    }

    public static String createKey(XfilUriEntity uriEntity) {
        String key = String.valueOf(uriEntity.name) + "-" + uriEntity.size;
        return key;
    }

    public static List<String> diff(XfilUriEntity uriEntity1, XfilUriEntity uriEntity2) throws Exception {
        ArrayList<String> diffList = new ArrayList<String>();
        if (uriEntity1.schemeId != uriEntity2.schemeId) {
            diffList.add("schemeId");
        }
        if (!BcStringUtil.equals(uriEntity1.directory, uriEntity2.directory)) {
            diffList.add("directory");
        }
        if (!BcStringUtil.equals(uriEntity1.name, uriEntity2.name)) {
            diffList.add("name");
        }
        if (uriEntity1.size != uriEntity2.size) {
            diffList.add("size");
        }
        if (BcTimeUtil.compare(uriEntity1.creationDatetime, uriEntity2.creationDatetime) != BcCompareUtil.Comparison.equals.value) {
            diffList.add("creationDatetime");
        }
        if (BcTimeUtil.compare(uriEntity1.lastModifiedDatetime, uriEntity2.lastModifiedDatetime) != BcCompareUtil.Comparison.equals.value) {
            diffList.add("lastModifiedDatetime");
        }
        return diffList;
    }

    public static List<String> diff(Path path1, Path path2) throws Exception {
        XfilUriEntity uriEntity1 = XfilUtil.toUriEntity(path1, true);
        XfilUriEntity uriEntity2 = XfilUtil.toUriEntity(path2, true);
        return XfilUtil.diff(uriEntity1, uriEntity2);
    }

    public static BcTableColumnModel createTableColumnModel_1() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().folder;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 60;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().fileName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 30;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "\u30b5\u30a4\u30ba";
        mmdField.dataClass = Long.class;
        mmdField.columnCount = 8;
        mmdField.fieldDisplay.horizonalAlignment = 4;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().fileExtension.toPlain();
        mmdField.dataClass = String.class;
        mmdField.columnCount = 8;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "\u30d5\u30e9\u30b0";
        mmdField.dataClass = Boolean.class;
        mmdField.columnCount = 6;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static BcTableColumnModel createTableColumnModel_2() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().fileName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 30;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "\u30b5\u30a4\u30ba";
        mmdField.dataClass = Long.class;
        mmdField.columnCount = 8;
        mmdField.fieldDisplay.horizonalAlignment = 4;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "\u4ef6\u6570";
        mmdField.dataClass = Long.class;
        mmdField.columnCount = 4;
        mmdField.fieldDisplay.horizonalAlignment = 4;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static boolean isAllowedFileExtention(Collection<String> fileExtentionCollection, String extention) throws Exception {
        if (BcCollectionUtil.isEmpty(fileExtentionCollection)) {
            return true;
        }
        if (!BcStringUtil.isEmpty(extention)) {
            for (String extention2 : fileExtentionCollection) {
                if (extention2.equalsIgnoreCase(extention)) {
                    return true;
                }
                if (!extention2.endsWith("*")) continue;
                return true;
            }
        }
        return false;
    }

    public static MovieInfo setMovieInfo(XfilUriEntity uriEntity, File file) throws Exception {
        MovieInfo movieInfo = FfprobeUtil.getMovieInfo(file);
        if (movieInfo != null) {
            uriEntity.width = movieInfo.width;
            uriEntity.height = movieInfo.height;
            uriEntity.durationMillis = movieInfo.durationMillis;
            uriEntity.mediaInfo = movieInfo.note;
        } else {
            uriEntity.width = -1;
            uriEntity.height = -1;
            uriEntity.durationMillis = -1L;
            uriEntity.mediaInfo = "ERROR";
        }
        return movieInfo;
    }

    public static String toPlaceholder(Placeholder placeholder) throws Exception {
        return "%" + placeholder.name() + "%";
    }

    public static String createFileName(long timeMillis, int width, int height, long entityId, String extention, String fileName) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (timeMillis >= 0L) {
            String HH_mm_ss = BcTimeUtil.toDurationString(timeMillis);
            String HHmmss = HH_mm_ss.replace(BcUnicode.colon.string, "");
            sb.append("_" + HHmmss);
        }
        String suffix = sb + "_" + width + "x" + height + "_" + entityId;
        return BcFileUtil.createFileName(fileName, extention, suffix);
    }

    public static File getTthumbnailsBaseDir() throws Exception {
        File dir = new File(AfbApplication.getInstance().toReal("${APP}data/thumbnails/"));
        return dir;
    }

    public static File getThumbnailsDir(long entityId) throws Exception {
        long[] res = XfilUtil.calcFolder(100, 2, entityId);
        File baseDir = XfilUtil.getTthumbnailsBaseDir();
        File dir = null;
        int i = 0;
        while (i < res.length) {
            long num = res[res.length - i - 1];
            String numStr = Long.toString(num);
            baseDir = dir = new File(baseDir, numStr);
            ++i;
        }
        return dir;
    }

    public static long[] calcFolder(int unit, int level, long entityId) throws Exception {
        long[] res = new long[level];
        int i = 0;
        while (i < level) {
            int levelWk = i + 1;
            int unitWk = (int)Math.pow(unit, levelWk);
            res[i] = XfilUtil.calcFolder(unitWk, entityId);
            ++i;
        }
        return res;
    }

    public static long calcFolder(int unit, long entityId) throws Exception {
        long entityIdWk = entityId - 0L;
        long unitBase = entityIdWk / (long)unit;
        long amari = entityIdWk % (long)unit;
        long folder = unitBase * (long)unit;
        if (amari == 0L) {
            --unitBase;
        }
        folder = unitBase * (long)unit + 1L;
        return folder;
    }

    public static BcResult deleteTthumbnails(XfilUriEntity uriEntity) throws Exception {
        BcResult result = new BcResult();
        if (BcStringUtil.isEmpty(uriEntity.thumbnailFiles)) {
            return result;
        }
        List<String> fileNameList = BcCsvUtil.parseCsvRow(uriEntity.thumbnailFiles, true);
        File dir = XfilUtil.getThumbnailsDir(uriEntity.id);
        int j = 0;
        while (j < fileNameList.size()) {
            String fileName = fileNameList.get(j);
            File file = new File(dir, fileName);
            BcLogUtil.info("DELETE:" + file.getPath());
            if (!file.exists()) {
                result.addError(BcWords.getInstance().File_does_not_exists("file=" + file.getPath()));
            } else {
                try {
                    BcFileUtil.deleteIfExists(file);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                    result.addError(ex);
                }
            }
            ++j;
        }
        return result;
    }

    public static SqlConditionParser createConditionParser(SqlContext sqlContext) throws Exception {
        SqlConditionParser conditionParser = new SqlConditionParser();
        conditionParser.setRangeEnabled(false);
        return conditionParser;
    }

    public static List<String> reformPath(Collection<String> pathCollection) throws Exception {
        ArrayList<String> newPathList = new ArrayList<String>();
        for (String path : pathCollection) {
            String newPath = null;
            try {
                newPath = BcFileUtil.reformPath(path);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                newPath = path;
            }
            newPathList.add(newPath);
        }
        return newPathList;
    }

    public static boolean isTarget(String targetPath, String exclusionPath, boolean ignoreCase) throws Exception {
        targetPath = BcFileUtil.reformPath(targetPath);
        exclusionPath = BcFileUtil.reformPath(exclusionPath);
        if (ignoreCase) {
            targetPath = targetPath.toUpperCase();
            exclusionPath = exclusionPath.toUpperCase();
        }
        return targetPath.startsWith(exclusionPath);
    }

    public static boolean isTargetExtention(Collection<String> etentionCollection, String extention2) throws Exception {
        for (String extention1 : etentionCollection) {
            if (!BcStringUtil.equalsIgnoreCase(extention1, extention2)) continue;
            return true;
        }
        return false;
    }

    public static enum Placeholder {
        fileBaseName,
        timeMillis,
        frameSizew,
        extention,
        entityId;

    }
}

