/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.wcb;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.dao.XdtsCustomSqlDAO;
import jp.co.extreme.module.xdts.dao.XdtsExtractionConditionDAO;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.wcb.XdtsWebParm;
import jp.co.extreme.sql.SqlWords;
import jp.co.extreme.web.jquery.jstree.JsTreeItem;
import jp.co.extreme.web.jquery.jstree.JsTreeUtil;

class XdtsTressCreator
extends BcLoggableObject {
    XdtsTressCreator() {
    }

    public JsTreeItem createTree(DtsSession dtsSessionMain, DtsSession dtsSessionWk, XdtsProfile profile) throws Exception {
        JsTreeItem rootTreeItem = new JsTreeItem();
        rootTreeItem.text = profile.name;
        rootTreeItem.note = profile.note;
        this.sqlList(dtsSessionMain, profile, rootTreeItem);
        this.extractionConditionList(dtsSessionMain, profile, rootTreeItem);
        return rootTreeItem;
    }

    protected Map<String, JsTreeItem> createGroup(Collection<XdtsCustomSql> customSqlCollection, Collection<XdtsExtractionCondition> extractionConditionCollection, JsTreeItem parentTreeItem) throws Exception {
        JsTreeItem treeItem2;
        JsTreeItem treeItem1;
        String key;
        HashMap<String, JsTreeItem> treeMap = new HashMap<String, JsTreeItem>();
        for (XdtsCustomSql xdtsCustomSql : customSqlCollection) {
            key = BcStringUtil.toNotNull(xdtsCustomSql.group);
            treeItem1 = (JsTreeItem)treeMap.get(key);
            if (treeItem1 == null) {
                treeItem1 = new JsTreeItem();
                treeItem1.text = key;
                treeMap.put(key, treeItem1);
            }
            treeItem2 = this.createTreItem(xdtsCustomSql);
            treeItem1.children.add(treeItem2);
        }
        for (XdtsExtractionCondition xdtsExtractionCondition : extractionConditionCollection) {
            key = BcStringUtil.toNotNull(xdtsExtractionCondition.group);
            treeItem1 = (JsTreeItem)treeMap.get(key);
            if (treeItem1 == null) {
                treeItem1 = new JsTreeItem();
                treeItem1.text = key;
                treeMap.put(key, treeItem1);
            }
            treeItem2 = this.createTreItem(xdtsExtractionCondition);
            treeItem1.children.add(treeItem2);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            parentTreeItem.children.add((JsTreeItem)entry.getValue());
        }
        return treeMap;
    }

    protected JsTreeItem createTreItem(XdtsCustomSql customSql) throws Exception {
        JsTreeItem treeItem = new JsTreeItem();
        treeItem.text = customSql.name;
        XdtsWebParm xdtsWebParm = new XdtsWebParm();
        xdtsWebParm.profileId = customSql.profileId;
        xdtsWebParm.schemaObjectType = XdtsConstants.SchemaObjectType.sql;
        xdtsWebParm.schemaObjectId = String.valueOf(customSql.getDataId());
        treeItem.userObject = xdtsWebParm;
        treeItem.note = customSql.note;
        return treeItem;
    }

    protected JsTreeItem createTreItem(XdtsExtractionCondition extractionCondition) throws Exception {
        JsTreeItem treeItem = new JsTreeItem();
        treeItem.text = extractionCondition.name;
        XdtsWebParm xdtsWebParm = new XdtsWebParm();
        xdtsWebParm.profileId = extractionCondition.profileId;
        xdtsWebParm.schemaObjectType = XdtsConstants.SchemaObjectType.condition;
        xdtsWebParm.schemaObjectId = String.valueOf(extractionCondition.id);
        treeItem.userObject = xdtsWebParm;
        treeItem.note = extractionCondition.note;
        return treeItem;
    }

    protected void sqlList(DtsSession dtsSessionMain, XdtsProfile profile, JsTreeItem parentTreeItem1) throws Exception {
        List customSqlList = XdtsCustomSqlDAO.getInstance().getList(dtsSessionMain, profile.getDataId());
        if (BcCollectionUtil.isEmpty(customSqlList)) {
            return;
        }
        JsTreeItem parentTreeItem2 = new JsTreeItem();
        parentTreeItem2.icon = JsTreeUtil.JsTreeIcon.jstree_folder.value;
        parentTreeItem2.text = String.format(String.valueOf(SqlWords.getInstance().sql) + "(%d)", customSqlList.size());
        parentTreeItem1.children.add(parentTreeItem2);
        HashMap<String, JsTreeItem> treeMap = new HashMap<String, JsTreeItem>();
        int i = 0;
        while (i < customSqlList.size()) {
            XdtsCustomSql customSql = (XdtsCustomSql)customSqlList.get(i);
            String key = BcStringUtil.toNotNull(customSql.group);
            JsTreeItem groupTreeItem = (JsTreeItem)treeMap.get(key);
            if (groupTreeItem == null) {
                groupTreeItem = new JsTreeItem();
                groupTreeItem.text = key;
                treeMap.put(key, groupTreeItem);
            }
            JsTreeItem treeItem1 = this.createTreItem(customSql);
            groupTreeItem.children.add(treeItem1);
            ++i;
        }
        for (Map.Entry mapEntry : treeMap.entrySet()) {
            parentTreeItem2.children.add((JsTreeItem)mapEntry.getValue());
        }
    }

    protected void extractionConditionList(DtsSession dtsSessionMain, XdtsProfile profile, JsTreeItem parentTreeItem1) throws Exception {
        List extractionConditionList = XdtsExtractionConditionDAO.getInstance().getList(dtsSessionMain, profile.getDataId());
        if (BcCollectionUtil.isEmpty(extractionConditionList)) {
            return;
        }
        JsTreeItem parentTreeItem2 = new JsTreeItem();
        parentTreeItem2.icon = JsTreeUtil.JsTreeIcon.jstree_folder.value;
        parentTreeItem2.text = String.format(BcWords.getInstance().extractionCondition + "(%d)", extractionConditionList.size());
        parentTreeItem1.children.add(parentTreeItem2);
        HashMap<String, JsTreeItem> treeMap = new HashMap<String, JsTreeItem>();
        int i = 0;
        while (i < extractionConditionList.size()) {
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)extractionConditionList.get(i);
            String key = BcStringUtil.toNotNull(extractionCondition.group);
            JsTreeItem groupTreeItem = (JsTreeItem)treeMap.get(key);
            if (groupTreeItem == null) {
                groupTreeItem = new JsTreeItem();
                groupTreeItem.text = key;
                treeMap.put(key, groupTreeItem);
            }
            JsTreeItem treeItem1 = this.createTreItem(extractionCondition);
            groupTreeItem.children.add(treeItem1);
            ++i;
        }
        for (Map.Entry mapEntry : treeMap.entrySet()) {
            parentTreeItem2.children.add((JsTreeItem)mapEntry.getValue());
        }
    }

    protected void tableList(DtsSession dtsSessionWk, XdtsProfile profile, JsTreeItem treeItemRoot) throws Exception {
        List<String> tableNameList = dtsSessionWk.getSqlContext().getTableNameList(dtsSessionWk.getConnection());
        JsTreeItem treeItem1 = new JsTreeItem();
        treeItem1.icon = JsTreeUtil.JsTreeIcon.jstree_folder.value;
        treeItem1.text = String.format(String.valueOf(BcWords.getInstance().table) + "(%d)", tableNameList.size());
        treeItemRoot.children.add(treeItem1);
        int i = 0;
        while (i < tableNameList.size()) {
            String tableName = tableNameList.get(i);
            JsTreeItem treeItem = new JsTreeItem();
            treeItem.text = tableName;
            XdtsWebParm xdtsWebParm = new XdtsWebParm();
            xdtsWebParm.profileId = profile.getDataId();
            xdtsWebParm.schemaObjectType = XdtsConstants.SchemaObjectType.table;
            xdtsWebParm.schemaObjectId = tableName;
            treeItem.userObject = xdtsWebParm;
            treeItem1.children.add(treeItem);
            ++i;
        }
    }

    protected void viewList(DtsSession dtsSessionWk, XdtsProfile profile, JsTreeItem treeItemRoot) throws Exception {
        List<String> viewNameList = dtsSessionWk.getSqlContext().getViewNameList(dtsSessionWk.getConnection());
        JsTreeItem treeItem2 = new JsTreeItem();
        treeItem2.icon = JsTreeUtil.JsTreeIcon.jstree_folder.value;
        treeItem2.text = String.format(String.valueOf(SqlWords.getInstance().view) + "(%d)", viewNameList.size());
        treeItemRoot.children.add(treeItem2);
        int i = 0;
        while (i < viewNameList.size()) {
            String viewName = viewNameList.get(i);
            JsTreeItem treeItem = new JsTreeItem();
            treeItem.text = viewName;
            XdtsWebParm xdtsWebParm = new XdtsWebParm();
            xdtsWebParm.profileId = profile.getDataId();
            xdtsWebParm.schemaObjectType = XdtsConstants.SchemaObjectType.view;
            xdtsWebParm.schemaObjectId = viewName;
            treeItem.userObject = xdtsWebParm;
            treeItem2.children.add(treeItem);
            ++i;
        }
    }
}

