/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.wcb;

import com.sun.xml.internal.ws.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.css.common.CssBuiler;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.component.WhcBuilder;
import jp.co.extreme.html.component.WhcButtonGroup;
import jp.co.extreme.html.component.WhcCheckBox;
import jp.co.extreme.html.component.WhcComponent;
import jp.co.extreme.html.component.WhcDiv;
import jp.co.extreme.html.component.WhcInput;
import jp.co.extreme.html.component.WhcRadioButton;
import jp.co.extreme.html.component.WhcTextArea;
import jp.co.extreme.html.component.WhcTextField;
import jp.co.extreme.html.component.WhcUtil;
import jp.co.extreme.lib.html.mdc.MdcConstants;
import jp.co.extreme.lib.html.mdc.MdcCreator;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsSqlParserUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v001.XdtsSelectContext;
import jp.co.extreme.module.xdts.wcb.XdtsControlUnit;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;

public class XdsSearchUtil
extends BcLoggableObject {
    public static List<XdtsControlUnit> createControlUnitList(WbfwWcbArgument wcbArg, XdtsCustomSql customSql, String elementName) throws Exception {
        ArrayList<XdtsControlUnit> controlUnitList = new ArrayList<XdtsControlUnit>();
        XdtsControlUnit controlUnit = new XdtsControlUnit();
        controlUnit.name = customSql.name;
        WhcTextArea textArea = new WhcTextArea(elementName, customSql.sql);
        controlUnit.whcComponent = textArea;
        CssBuiler cssBuiler = new CssBuiler();
        cssBuiler.width("100%").height("14em").padding("0.2rem").border("0px").background_color("var(--primary-bg)").outline("none");
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.style = cssBuiler.build();
        textArea.setGlobalAttribute(globalAttribute);
        controlUnitList.add(controlUnit);
        return controlUnitList;
    }

    public static List<XdtsControlUnit> createControlUnitList(XdtsExtractionCondition extractionCondition, XdtsUserSetting userSetting) throws Exception {
        HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
        WhcBuilder whcBuilder = new WhcBuilder(htmlBuilder);
        ArrayList<XdtsControlUnit> controlUnitList = new ArrayList<XdtsControlUnit>();
        int i = 0;
        while (i < extractionCondition.selectContextList.size()) {
            XdtsSelectContext selectContext = extractionCondition.selectContextList.get(i);
            List<XdtsControlContext> controlContextList2 = XdtsSqlParserUtil.sortControlContext(selectContext.controlContextList);
            boolean isEdit = true;
            int j = 0;
            while (j < controlContextList2.size()) {
                XdtsControlContext controlContext = controlContextList2.get(j);
                if (isEdit || controlContext.displayOrder > 0) {
                    XdtsControlUnit controlUnit;
                    String name = "v" + i + "-" + j;
                    if (controlContext.contextType == XdtsConstants.ContextType.RowLimit || controlContext.contextType == XdtsConstants.ContextType.OrderBy) {
                        name = controlContext.name;
                    }
                    if ((controlUnit = XdsSearchUtil.createControlUnit(selectContext, controlContext, userSetting, isEdit, name)) != null) {
                        controlUnitList.add(controlUnit);
                    }
                }
                ++j;
            }
            ++i;
        }
        return controlUnitList;
    }

    public static XdtsControlUnit createControlUnit(XdtsSelectContext selectContext, XdtsControlContext controlContext, XdtsUserSetting userSetting, boolean isEdit, String name) throws Exception {
        BcLogUtil.debug("createControlUnit.controlType=" + (Object)((Object)controlContext.controlType) + " controlContext.name=" + controlContext.name);
        XdtsControlUnit controlUnit = new XdtsControlUnit();
        controlUnit.name = name;
        controlUnit.selectContext = selectContext;
        controlUnit.controlContext = controlContext;
        controlUnit.itemName = controlContext.displayName;
        if (controlContext.contextType == XdtsConstants.ContextType.General) {
            controlUnit.whcComponent = XdsSearchUtil.createHtmlComponent(controlContext, userSetting, controlUnit.name);
        } else if (controlContext.contextType == XdtsConstants.ContextType.OrderBy || controlContext.contextType == XdtsConstants.ContextType.RowLimit) {
            controlUnit.whcComponent = XdsSearchUtil.createHtmlComponent(controlContext, userSetting, controlUnit.name);
        } else {
            return null;
        }
        return controlUnit;
    }

    public static WhcComponent createHtmlComponent(XdtsControlContext controlContext, XdtsUserSetting userSetting, String inputName) throws Exception {
        BcLogUtil.debug("controlContext.controlType=" + (Object)((Object)controlContext.controlType) + " controlContext.name=" + controlContext.name);
        WhcComponent whcComponent = null;
        String defaultValue = XdtsUtil.getDefaultValue(controlContext, userSetting);
        BcLogUtil.debug(String.valueOf(controlContext.name) + ":defaultValue=" + defaultValue);
        List<String> optionList = XdtsUtil.createOptionList(controlContext);
        if (controlContext.controlType == XdtsConstants.ControlType.Text) {
            if (BcCollectionUtil.isEmpty(optionList)) {
                if (controlContext.rowCount > 1) {
                    WhcTextArea textArea = new WhcTextArea(inputName, BcStringUtil.toString(defaultValue));
                    textArea.columnCount = controlContext.columnCount;
                    textArea.rowCount = controlContext.rowCount;
                    whcComponent = textArea;
                } else {
                    WhcTextField textField = new WhcTextField(inputName, BcStringUtil.toString(defaultValue), controlContext.columnCount);
                    HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
                    globalAttribute.clazz = BcStringUtil.toSsv(MdcCreator.getInstance().text_field__input());
                    textField.setGlobalAttribute(globalAttribute);
                    WhcDiv div1 = WhcUtil.createDiv(new Object[]{MdcConstants.MdcClass.mdc_text_field, MdcConstants.MdcClass.mdc_text_field__dense, MdcConstants.MdcClass.mdc_text_field__outlined});
                    div1.childList.add(textField);
                    WhcDiv div2 = WhcUtil.createDiv(new Object[]{MdcConstants.MdcClass.mdc_notched_outline});
                    div1.childList.add(div2);
                    WhcDiv div31 = WhcUtil.createDiv(new Object[]{MdcConstants.MdcClass.mdc_notched_outline__leading});
                    div2.childList.add(div31);
                    WhcDiv div32 = WhcUtil.createDiv(new Object[]{MdcConstants.MdcClass.mdc_notched_outline__notch});
                    div2.childList.add(div32);
                    WhcDiv div33 = WhcUtil.createDiv(new Object[]{MdcConstants.MdcClass.mdc_notched_outline__trailing});
                    div2.childList.add(div33);
                    whcComponent = div1;
                }
            } else {
                WhcTextField textField = new WhcTextField(inputName, BcStringUtil.toString(defaultValue), controlContext.columnCount);
                textField.optionList = new ArrayList();
                textField.list = String.valueOf(inputName) + "-option";
                textField.optionList.addAll(optionList);
                whcComponent = textField;
            }
        } else if (controlContext.controlType == XdtsConstants.ControlType.CheckBox) {
            WhcButtonGroup buttonGroup = new WhcButtonGroup(inputName);
            if (!BcCollectionUtil.isEmpty(optionList)) {
                List<String> tmpList = BcCsvUtil.parseCsvRow(BcStringUtil.toString(defaultValue), true);
                List<String> displayNameList = null;
                displayNameList = BcStringUtil.isEmpty(controlContext.displayName) ? optionList : BcCsvUtil.parseCsvRow(controlContext.displayName, true);
                int i = 0;
                while (i < optionList.size()) {
                    String option = optionList.get(i);
                    String displayName = displayNameList.get(i);
                    WhcCheckBox checkBox = new WhcCheckBox(option, String.valueOf(displayName) + "  ");
                    tmpList.contains(option);
                    if (tmpList.contains(option)) {
                        checkBox.checked = true;
                    }
                    buttonGroup.childList.add(checkBox);
                    ++i;
                }
            }
            whcComponent = buttonGroup;
        } else if (controlContext.controlType == XdtsConstants.ControlType.RadioButton) {
            WhcButtonGroup buttonGroup = new WhcButtonGroup(inputName);
            if (!BcCollectionUtil.isEmpty(optionList)) {
                for (String option : optionList) {
                    WhcRadioButton radioButton = new WhcRadioButton(option, option);
                    if (option.equals(defaultValue)) {
                        radioButton.checked = true;
                    }
                    buttonGroup.childList.add(radioButton);
                }
            }
            whcComponent = buttonGroup;
        } else if (controlContext.controlType == XdtsConstants.ControlType.Boolean) {
            WhcButtonGroup buttonGroup = new WhcButtonGroup(inputName);
            WhcRadioButton radioButtonNull = new WhcRadioButton("null", BcWords.getInstance().notSpecified);
            WhcRadioButton radioButtonTrue = new WhcRadioButton(Boolean.toString(true), StringUtils.capitalize((String)Boolean.toString(true)));
            WhcRadioButton radioButtonFalse = new WhcRadioButton(Boolean.toString(false), StringUtils.capitalize((String)Boolean.toString(false)));
            if (BcStringUtil.isEmpty((Object)defaultValue)) {
                radioButtonNull.checked = true;
            } else if (BcBooleanUtil.parseBoolean(BcStringUtil.toString(defaultValue)).booleanValue()) {
                radioButtonTrue.checked = true;
            } else {
                radioButtonFalse.checked = true;
            }
            buttonGroup.childList.add(radioButtonNull);
            buttonGroup.childList.add(radioButtonTrue);
            buttonGroup.childList.add(radioButtonFalse);
            int i = 0;
            while (i < buttonGroup.childList.size()) {
                WhcInput whcImput = (WhcInput)buttonGroup.childList.get(i);
                whcImput.name = buttonGroup.name;
                ++i;
            }
            whcComponent = buttonGroup;
        } else {
            throw new Exception("controlContext.controlType=" + (Object)((Object)controlContext.controlType));
        }
        return whcComponent;
    }

    public static String createCondition(HtmlBuilder htmlBuilder, String inputName, List<String> optionList, List displayNameList, String defaultValue, String title) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(htmlBuilder.div_start(ExtwCssUtil.ExtwClass.extw_box_radius_8px.className, ExtwCssUtil.ExtwClass.extw_box_shadow_6px.className, ExtwCssUtil.ExtwClass.extw_padding_08rem.className));
        sb.append(htmlBuilder.p(title, true, true));
        XdtsControlContext controlContext = new XdtsControlContext();
        controlContext.controlType = XdtsConstants.ControlType.CheckBox;
        controlContext.options = BcCsvUtil.toCsv(optionList, true);
        controlContext.defaultValue = defaultValue;
        if (!BcCollectionUtil.isEmpty(displayNameList)) {
            controlContext.displayName = BcCsvUtil.toCsv(displayNameList, true);
        }
        XdtsUserSetting userSetting = null;
        WhcComponent whcComponent = XdsSearchUtil.createHtmlComponent(controlContext, userSetting, inputName);
        WhcBuilder whcBuilder = new WhcBuilder(htmlBuilder);
        sb.append((CharSequence)whcBuilder.createComponentHtml(whcComponent, true));
        sb.append(htmlBuilder.div_end());
        return sb.toString();
    }

    public static String createCondition(HtmlBuilder htmlBuilder, String inputName, Collection<? extends Map.Entry> optionCollection, String defaultValue, String title) throws Exception {
        ArrayList<String> optionList = new ArrayList<String>();
        ArrayList displayNameList = new ArrayList();
        for (Map.Entry entry : optionCollection) {
            optionList.add((String)entry.getKey());
            displayNameList.add(entry.getValue());
        }
        return XdsSearchUtil.createCondition(htmlBuilder, inputName, optionList, displayNameList, defaultValue, title);
    }
}

