/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.swg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.table.BcCsvToTable;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcCompareUtil;
import jp.co.extreme.module.xdts.swg.XdtsTableComparePanel;
import jp.co.extreme.module.xdts.swg.XdtsTablePanelCompare;
import jp.co.extreme.poi.PoiWorkbookUtil;

public class XdtsTableCompare
extends BcLoggableObject {
    XdtsTableComparePanel tableComparePanel;
    Map<String, Object> pointMap;
    List<Object> pointList;

    public void test1() throws Exception {
        File baseDir = new File("X:/ext_develop/ews_ext_g32/63_91_11_test/temp");
        File file1 = new File(baseDir, "NLS_\u51e6103040_InLight\u30c7\u30fc\u30bf\u30ec\u30d3\u30e5\u30fc\u660e\u7d30_AP\u66f4\u65b0\u524d.csv");
        File file2 = new File(baseDir, "NLS_\u51e6103040_InLight\u30c7\u30fc\u30bf\u30ec\u30d3\u30e5\u30fc\u660e\u7d30_AP\u66f4\u65b0\u5f8c.csv");
        BcTableModel tableModel1 = this.createTable1(file1);
        BcTableModel tableModel2 = this.createTable1(file2);
        this.compare(tableModel1, tableModel2);
        this.tableComparePanel = new XdtsTableComparePanel();
        this.tableComparePanel.tableView1 = new XdtsTablePanelCompare(tableModel1, tableModel1.getTableColumnModel());
        this.tableComparePanel.tableView1.pointMap = this.pointMap;
        this.tableComparePanel.tableView2 = new XdtsTablePanelCompare(tableModel2, tableModel2.getTableColumnModel());
        this.tableComparePanel.tableView2.pointMap = this.pointMap;
        this.tableComparePanel.init();
        this.tableComparePanel.showAsFrame();
    }

    public BcTableModel createTable1(File csvFile) throws Exception {
        this.getLogger().info("CSV\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u307f\u4e2d... \u30d5\u30a1\u30a4\u30eb=" + csvFile.getPath());
        FileInputStream fileInputStream = new FileInputStream(csvFile);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        BcTableModel tableModel = BcCsvToTable.getInstance().csvToTable(inputStreamReader, 1);
        return tableModel;
    }

    public void compare(BcTableModel tableModel1, BcTableModel tableModel2) throws Exception {
        this.pointMap = new HashMap<String, Object>();
        this.pointList = new ArrayList<Object>();
        int i = 0;
        while (i < tableModel1.getRowCount()) {
            int n = 0;
            while (n < tableModel1.getColumnCount()) {
                if (n != 0 && n != 56) {
                    Object value2;
                    if (tableModel2.getRowCount() <= i) {
                        this.addPoint(i, n, "\u884c\u7121\u3057");
                        break;
                    }
                    Object value1 = tableModel1.getValueAt(i, n);
                    if (!BcCompareUtil.equals(value1, value2 = tableModel2.getValueAt(i, n), false)) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("\u884c=" + (i + 1) + " \u5217=" + (n + 1) + "(" + PoiWorkbookUtil.toColumnName(n) + ")");
                        sb.append("\n value1=" + value1);
                        sb.append("\n value2=" + value2);
                        this.getLogger().info(sb);
                        this.addPoint(i, n, sb);
                    }
                }
                ++n;
            }
            ++i;
        }
        this.getLogger().info("pointMap.size()=" + this.pointMap.size());
        StringBuilder sb = new StringBuilder();
        for (Object e : this.pointList) {
            sb.append(e);
            sb.append("\n");
            sb.append("\n");
        }
        File file = BcRuntimeUtil.getUserDir();
        File destFile = new File(file, "csv\u6bd4\u8f03\u7d50\u679c_" + BcFileUtil.create_yyyyMMdd_HHmmssSSS() + ".txt");
        this.getLogger().info("destFile=" + destFile.getPath());
        BcFileUtil.save(destFile, sb.toString());
    }

    public void addPoint(int rowId, int columnId, Object obj) throws Exception {
        String key = XdtsTableCompare.createKey(rowId, columnId);
        this.pointMap.put(key, obj);
        this.pointList.add(obj);
    }

    public static String createKey(int rowId, int columnId) {
        return String.valueOf(rowId) + "-" + columnId;
    }
}

