/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.io.File;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.stage.Window;
import jp.co.extreme.base.core.BcJavaConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsAbstractConditionPane;
import jp.co.extreme.module.xdts.fx.XdtsAbstractTransferPane;
import jp.co.extreme.module.xdts.fx.XdtsCopyRecordConditionPane;
import jp.co.extreme.module.xdts.fx.XdtsCreateCraeteTableQueryConditionPane;
import jp.co.extreme.module.xdts.fx.XdtsUpdateQueryConditionPane;
import jp.co.extreme.module.xdts.model.XdtsProcessCondition;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.stub.XdtsSchemaStub;
import jp.co.extreme.scf5.stub.ScfPropertyStub;
import jp.co.extreme.sql.SqlWords;

public class XdtsTransferPane
extends XdtsAbstractTransferPane {
    Mode mode;
    XdtsProcessCondition processCondition;
    XdtsAbstractConditionPane conditionPane;

    public void setProfile(XdtsProfile profile1, Mode mode) throws Exception {
        this.setProfile(profile1);
        this.mode = mode;
        this.setComponentCommon1();
        this.setComponentCommon2();
        switch (mode) {
            case createCreateTableSql: {
                this.setComponent_createCreateTableSql();
                break;
            }
            case createInsertSql: {
                this.setComponent_createInsertSql();
                break;
            }
            case dropTable: 
            case truncateTable: 
            case tableManipulation: 
            case dropView: {
                this.setComponent_updateQuery();
                break;
            }
            case copyToOtherDb: {
                this.setComponent_copyToOther();
            }
        }
        this.title = mode.title;
        this.processCondition = this.createCondition();
        this.conditionPane.setCondition(this.processCondition);
    }

    protected XdtsProcessCondition createCondition() throws Exception {
        XdtsProcessCondition processCondition = new XdtsProcessCondition();
        String propVal = ScfPropertyStub.getInstance().getProperty(XdtsConstants.TableName.xdts_property.name(), XdtsConstants.Property.destFile.id);
        File destFile = null;
        destFile = BcStringUtil.isEmpty(propVal) ? new File(System.getProperty(BcJavaConstants.SysKey.user_home.value), "rydeen_sql.txt") : new File(propVal);
        processCondition.destFilePath = destFile.getPath();
        propVal = ScfPropertyStub.getInstance().getProperty(XdtsConstants.TableName.xdts_property.name(), XdtsConstants.Property.destDir.id);
        File destDir = null;
        destDir = BcStringUtil.isEmpty(propVal) ? new File(System.getProperty(BcJavaConstants.SysKey.user_home.value)) : new File(propVal);
        processCondition.destDirPath = destDir.getPath();
        propVal = ScfPropertyStub.getInstance().getProperty(XdtsConstants.TableName.xdts_property.name(), XdtsConstants.Property.errorFile.id);
        File errFile = null;
        errFile = BcStringUtil.isEmpty(propVal) ? new File(System.getProperty(BcJavaConstants.SysKey.user_home.value), "rydeen_error.txt") : new File(propVal);
        processCondition.errorFilePath = errFile.getPath();
        return processCondition;
    }

    protected void setComponent_updateQuery() throws Exception {
        this.conditionPane = new XdtsUpdateQueryConditionPane(this.stage, this.mode);
        this.titledPane2.setContentNode((Node)this.conditionPane);
    }

    protected void setComponent_createCreateTableSql() throws Exception {
        this.conditionPane = new XdtsCreateCraeteTableQueryConditionPane(this.stage, this.profile.productId);
        this.titledPane2.setContentNode((Node)this.conditionPane);
    }

    protected void setComponent_createInsertSql() throws Exception {
        this.conditionPane = new XdtsCopyRecordConditionPane(this.stage, this.mode, this.profile.productId);
        this.titledPane2.setContentNode((Node)this.conditionPane);
    }

    protected void setComponent_copyToOther() throws Exception {
        this.conditionPane = new XdtsCopyRecordConditionPane(this.stage, this.mode, -1);
        this.titledPane2.setContentNode((Node)this.conditionPane);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource().hashCode() == this.executeButton.hashCode()) {
            this.conditionPane.getCondition(this.processCondition);
            this.processCondition.profileId = this.profile.getDataId();
            this.processCondition.schemaObjectList = this.schemaObjectSelectionPane.getSelecteSchemaObjectList();
            BcResult result = new BcResult();
            if (BcCollectionUtil.isEmpty(this.processCondition.schemaObjectList)) {
                result.addError(XdtsWords.getInstance().\u5bfe\u8c61\u306e\u30b9\u30ad\u30fc\u30de\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093);
            }
            switch (this.mode) {
                case tableManipulation: {
                    if (!BcStringUtil.isEmpty(this.processCondition.query)) break;
                    result.addError(XdtsWords.getInstance().\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u304c\u691c\u51fa\u3067\u307e\u305b\u3093);
                    break;
                }
                case copyToOtherDb: {
                    if (this.processCondition.copyRowUnit > 0L) break;
                    result.addError(XdtsWords.getInstance().\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u304c\u691c\u51fa\u3067\u307e\u305b\u3093);
                }
            }
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().warning, 2);
                return;
            }
            String msg = "\u672c\u5f53\u306b\u5b9f\u884c\u3057\u3066\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f";
            if (FxOptionPane.showConfirmDialog((Node)this, (Object)msg, BcWords.getInstance().warning, 3) != 0) {
                return;
            }
            switch (this.mode) {
                case createCreateTableSql: {
                    XdtsSchemaStub.getInstance().createCrateTableSql(this.processCondition, this.title);
                    break;
                }
                case createInsertSql: {
                    XdtsSchemaStub.getInstance().createInsertSql(this.processCondition, this.title, (Window)this.stage);
                    break;
                }
                case dropTable: 
                case truncateTable: 
                case tableManipulation: 
                case dropView: {
                    XdtsSchemaStub.getInstance().updateQuery(this.processCondition, this.title, (Window)this.stage);
                    break;
                }
                case copyToOtherDb: {
                    XdtsSchemaStub.getInstance().copyToOther(this.processCondition, this.title, (Window)this.stage);
                }
            }
            if (this.eventHandler != null) {
                ActionEvent actionEvent = new ActionEvent();
                this.eventHandler.handle((Event)actionEvent);
            }
        }
    }

    @Override
    protected void windowShown() throws Exception {
        this.conditionPane.requestFocus();
    }

    public static enum Mode {
        createCreateTableSql(XdtsWords.getInstance().createCreateTableSql),
        createInsertSql(XdtsWords.getInstance().createInsertSql),
        dropTable(SqlWords.getInstance().sql_DROP_TABLE),
        truncateTable(SqlWords.getInstance().sql_TRUNCATE_TABLE),
        tableManipulation("????"),
        dropView(SqlWords.getInstance().sql_DROP_VIEW),
        copyToOtherDb(XdtsWords.getInstance().copyToOtherDb);

        public final String title;

        private Mode(String title) {
            this.title = title;
        }
    }
}

