/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.fx.control.FxTabPane;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.mmdx.common.MmdxUtil;
import jp.co.extreme.module.mmdx.fx.MmdxFieldListPane;
import jp.co.extreme.module.mmdx.model.MmdxField;
import jp.co.extreme.module.mmdx.model.MmdxIndex;
import jp.co.extreme.module.mmdx.model.MmdxModel;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.stub.XdtsSchemaStub;
import jp.co.extreme.scf6.fx.TmpTableViewPane;
import jp.co.extreme.sql.SqlType;
import jp.co.extreme.sql.SqlWords;

public class XdtsTableInfoPane
extends FxBorderPane {
    XdtsProfile profile;
    String tableName;
    FxTabPane tabPane1 = new FxTabPane();
    FxTabPane tabPane2 = new FxTabPane();
    DtsWordManager wordManager;

    public XdtsTableInfoPane(XdtsProfile profile, String tableName, DtsWordManager wordManager) throws Exception {
        this.profile = profile;
        this.tableName = tableName;
        this.wordManager = wordManager;
        MmdModel mmdModel = XdtsSchemaStub.getInstance().getModelMetaData(profile.getDataId(), tableName);
        MmdxModel mmdxModel = MmdxUtil.toXmmdModel(mmdModel);
        MmdxFieldListPane columnDefinePane = new MmdxFieldListPane();
        columnDefinePane.setData(mmdxModel, wordManager);
        this.setCenter((Node)columnDefinePane);
        this.tabPane1.setSide(Side.LEFT);
        this.setCenter((Node)this.tabPane1);
        Tab columnTab = new Tab();
        columnTab.setText(SqlWords.getInstance().columnDefine);
        columnTab.setContent((Node)columnDefinePane);
        columnTab.closableProperty().set(false);
        this.tabPane1.getTabs().add((Object)columnTab);
        this.tabPane2.setSide(Side.TOP);
        Tab indexTab = new Tab();
        indexTab.setText(SqlWords.getInstance().index);
        indexTab.setContent((Node)this.tabPane2);
        indexTab.closableProperty().set(false);
        this.tabPane1.getTabs().add((Object)indexTab);
        for (MmdxIndex mmdxIndex : mmdxModel.indexNameMap.values()) {
            Node node = this.createIndexInfo(mmdxModel, mmdxIndex);
            boolean isPrimaryKey = false;
            isPrimaryKey = mmdxIndex.indexName.equalsIgnoreCase(mmdxModel.primaryIndexName);
            Tab keyTab = new Tab();
            if (isPrimaryKey) {
                keyTab.setText("[PK]" + mmdxIndex.indexName);
            } else {
                keyTab.setText(mmdxIndex.indexName);
            }
            keyTab.setContent(node);
            keyTab.closableProperty().set(false);
            this.tabPane2.getTabs().add((Object)keyTab);
        }
        FxUtil.defaultInitialize((Node)this);
    }

    protected Node createIndexInfo(MmdxModel mmdxModel, MmdxIndex mmdxIndex) throws Exception {
        ArrayList<MmdxField> fieldList = new ArrayList<MmdxField>();
        for (MmdIndexElement indexElement : mmdxIndex.indexElementList) {
            MmdxField mmdxField = mmdxModel.getFieldByName(indexElement.columnName);
            fieldList.add(mmdxField);
        }
        BcTableModel tableModel = XdtsTableInfoPane.createTableModel(fieldList, mmdxModel.tableName, this.wordManager);
        FxTableView tableView = new FxTableView();
        FxTableUtil.createColumn(tableModel.getTableColumnModel(), tableView, null);
        FxTableRowList tableRowList = new FxTableRowList(tableModel);
        tableView.setItems(tableRowList);
        TmpTableViewPane tmpTableViewPane = new TmpTableViewPane();
        tmpTableViewPane.setTableView(tableView);
        tmpTableViewPane.tableControlPane.setData(tableModel.getTableColumnModel(), tableModel, null);
        tmpTableViewPane.tableControlPane.setTitle(mmdxModel.tableName);
        return tmpTableViewPane;
    }

    public static BcTableModel createTableModel(List<MmdxField> fieldList, String tableName, DtsWordManager wordManager) throws Exception {
        BcTableColumnModel tableColumnModel = XdtsUtil.createColumnDefineTableColumnModel();
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        for (MmdxField mmdxField : fieldList) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(mmdxField.ordinalPosition);
            row.add(mmdxField.columnName);
            Object sqlTypeStr = null;
            SqlType sqlType = SqlType.getById(mmdxField.sqlTypeId);
            sqlTypeStr = sqlType != null ? sqlType.name() : Integer.valueOf(mmdxField.sqlTypeId);
            row.add(sqlTypeStr);
            row.add(mmdxField.dataSize);
            row.add(mmdxField.decimalDigit);
            row.add(BcBooleanUtil.toYN(mmdxField.nullable));
            row.add(XdtsUtil.getLogicalName(tableName, mmdxField, wordManager));
            row.add(mmdxField.tableName);
            tableModel.addRow(row);
        }
        return tableModel;
    }
}

