/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TablePosition;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsProfileTableModel;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.stub.XdtsProfileStub;

public class XdtsProfileSelectPane
extends FxDecoratePane {
    XdtsProfileTableModel profileTableModel = new XdtsProfileTableModel();
    Button selectButton;
    Button closeButton;
    InnerTableView tableView = new InnerTableView();
    Number nextRowId;
    XdtsProfile selectedValue;
    public Stage stage = new FxStage();

    public XdtsProfileSelectPane() throws Exception {
        this.selectButton = FxUtil.createOkButton(BcWords.getInstance().select, null);
        this.selectButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.selectButton);
        this.closeButton = FxUtil.createCloseButton();
        this.closeButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.closeButton);
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.profileTableModel.profileList = XdtsProfileStub.getInstance().getProfileList();
        FxTableRowList tableRowList = new FxTableRowList(this.profileTableModel);
        this.tableView = new InnerTableView();
        BcTableColumnModel tableColumnModel = XdtsUtil.createProfileTableColumnModel();
        FxTableUtil.createColumn(tableColumnModel, this.tableView, null);
        this.tableView.setItems(tableRowList);
        this.tableView.setEditable(false);
        this.setCenter((Node)this.tableView);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.selectButton) {
            this.selectedValue = this.profileTableModel.profileList.get(this.nextRowId.intValue());
            this.close();
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
    }

    public XdtsProfile show(Window ownerWindow) throws Exception {
        this.selectedValue = null;
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(940.0);
        this.stage.setHeight(520.0);
        this.stage.setResizable(true);
        this.stage.setTitle(XdtsWords.getInstance().dataSourceList);
        Image image = FxImageHelper.getImage("db_64x64.png");
        this.stage.getIcons().add((Object)image);
        this.stage.showAndWait();
        return this.selectedValue;
    }

    static /* synthetic */ void access$0(XdtsProfileSelectPane xdtsProfileSelectPane, Throwable throwable) {
        xdtsProfileSelectPane.handleException(throwable);
    }

    class InnerTableView<S>
    extends FxTableView<S> {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            XdtsProfileSelectPane.this.nextRowId = nextRowId;
        }

        @Override
        public void rowSelected(FxTableView tableView, ObservableList<TablePosition> tablePositionList, MouseEvent ev, boolean doubleClicked) throws Exception {
            super.rowSelected(tableView, tablePositionList, ev, doubleClicked);
            if (doubleClicked) {
                TablePosition tablePosition = (TablePosition)tablePositionList.get(0);
                XdtsProfileSelectPane.this.nextRowId = tablePosition.getRow();
                XdtsProfileSelectPane.this.selectedValue = XdtsProfileSelectPane.this.profileTableModel.profileList.get(tablePosition.getRow());
                XdtsProfileSelectPane.this.close();
            }
        }
    }
}

