/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.event.BcEventHandlerList;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.thread.BcRunnable;
import jp.co.extreme.base.util.BcExceptionUtil;
import jp.co.extreme.base.util.BcInstanceManager;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.etc.model.EtcWord;
import jp.co.extreme.etc.util.EtcWordUtil;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTabPane;
import jp.co.extreme.fx.extension.FxxAbstractDesktopPane;
import jp.co.extreme.fx.extension.FxxProgressIndicationPane;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsDataImportWizard;
import jp.co.extreme.module.xdts.fx.XdtsDatasourcePane;
import jp.co.extreme.module.xdts.fx.XdtsLogicalNameImportPane;
import jp.co.extreme.module.xdts.fx.XdtsProfileTreePane;
import jp.co.extreme.module.xdts.fx.XdtsTableInfoPane;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.stub.XdtsProfileStub;
import jp.co.extreme.module.xdts.stub.XdtsWordStub;
import jp.co.extreme.module.xdts.swg.XdtsDataViewPanel_Sql;
import jp.co.extreme.module.xdts.swg.XdtsLogicalNamePanel;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlWords;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.task.TskAbstractCallable;

public class XdtsProfilePane
extends FxxAbstractDesktopPane {
    FxBorderPane borderPane1 = new FxBorderPane();
    XdtsDatasourcePane datasourcePane = new XdtsDatasourcePane(XdtsDatasourcePane.Mode.display);
    FxFlowPane controlPane = new FxFlowPane(21);
    FxButton sqlButton;
    FxButton importButton;
    FxButton logicalNameCsvImportButton;
    FxButton logicalNameCsvExportButton;
    FxButton logicalNameButton;
    SplitPane splitPane;
    XdtsProfileTreePane profileTreePane;
    FxTabPane tabPane1;
    XdtsProfile profile;
    SqlContext sqlContext;
    MenuItem closeMenuItem;
    DtsWordManager wordManager;
    BcEventHandlerList eventHandlerList;
    FxxProgressIndicationPane progressIndicationPane;
    XdtsLogicalNamePanel logicalNamePanel;

    public XdtsProfilePane() throws Exception {
        this.sqlButton = new FxButton(SqlWords.getInstance().sql);
        this.importButton = new FxButton();
        this.logicalNameCsvImportButton = new FxButton();
        this.logicalNameCsvExportButton = new FxButton();
        this.logicalNameButton = new FxButton();
        this.splitPane = new SplitPane();
        this.tabPane1 = new FxTabPane();
        this.closeMenuItem = new MenuItem(BcWords.getInstance().close);
        this.eventHandlerList = new BcEventHandlerList();
        this.progressIndicationPane = new FxxProgressIndicationPane();
    }

    protected void setContents() throws Exception {
        this.datasourcePane.setPrefWidth(760.0);
        FxUtil.setEditable((Node)this.datasourcePane, false);
        this.borderPane1.setLeft((Node)this.datasourcePane);
        this.sqlButton.setOnAction(this.actionEventHandler);
        this.sqlButton.setGraphic((Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
        this.sqlButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_queryButton));
        FxNodeUnit nodeUnit = new FxNodeUnit(null, new Node[]{this.sqlButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.importButton.setOnAction(this.actionEventHandler);
        this.importButton.setText(BcWords.getInstance().import_);
        this.importButton.setGraphic((Node)FxImageHelper.createImageView_icon("import_64x64.png"));
        this.importButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_dataImport));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.importButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.logicalNameCsvImportButton.setOnAction(this.actionEventHandler);
        this.logicalNameCsvImportButton.setText(XdtsWords.getInstance().Logical_name_CSV_import);
        this.logicalNameCsvImportButton.setGraphic((Node)FxImageHelper.createImageView_icon("import_64x64.png"));
        this.logicalNameCsvImportButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_dataImport));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.logicalNameCsvImportButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.logicalNameCsvExportButton.setOnAction(this.actionEventHandler);
        this.logicalNameCsvExportButton.setText(XdtsWords.getInstance().Logical_name_CSV_export);
        this.logicalNameCsvExportButton.setGraphic((Node)FxImageHelper.createImageView_icon("export_64x64.png"));
        this.logicalNameCsvExportButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_dataImport));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.logicalNameCsvExportButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.borderPane1.setCenter((Node)this.controlPane);
        this.setTop((Node)this.borderPane1);
        this.tabPane1.setSide(Side.TOP);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setProfile(XdtsProfile profile) throws Exception {
        this.profile = profile;
        this.datasourcePane.setData(profile);
        this.setContentNode((Node)this.splitPane);
        this.splitPane.getItems().add((Object)this.progressIndicationPane);
        this.progressIndicationPane.msgLabel.setText(BcWords.getInstance().connectingTo(profile.name));
    }

    protected void setup() throws Exception {
        SetupTask setupTask = new SetupTask();
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future future = executorService.submit(setupTask);
    }

    public void addTable(String tableName, int index) throws Exception {
        Tab tab = FxUtil.findTabByName(this.tabPane1, tableName);
        if (tab != null) {
            this.tabPane1.getSelectionModel().select((Object)tab);
            return;
        }
        XdtsTableInfoPane tableInfoPane = new XdtsTableInfoPane(this.profile, tableName, this.wordManager);
        tab = new Tab();
        tab.setText(XdtsUtil.apendLogicalName(this.wordManager, tableName));
        tab.setGraphic((Node)FxImageHelper.createImageView_icon("table_64x64.png"));
        tab.setContent((Node)tableInfoPane);
        if (index < 0) {
            this.tabPane1.getTabs().add((Object)tab);
            this.tabPane1.getSelectionModel().select((Object)tab);
        } else {
            this.tabPane1.getTabs().add(index, (Object)tab);
        }
    }

    public void reflesh(String tableName) throws Exception {
        Tab tab = FxUtil.findTabByName(this.tabPane1, tableName);
        if (tab == null) {
            return;
        }
        int index = this.tabPane1.getTabs().indexOf((Object)tab);
        Tab selectedTab = (Tab)this.tabPane1.getSelectionModel().getSelectedItem();
        boolean isSelected = tab == selectedTab;
        this.tabPane1.getTabs().remove((Object)tab);
        this.addTable(tab.getText(), index);
        if (isSelected) {
            tab = FxUtil.findTabByName(this.tabPane1, tableName);
            this.tabPane1.getSelectionModel().select((Object)tab);
        }
    }

    public void reflesh() throws Exception {
        ObservableList tabList = this.tabPane1.getTabs();
        int i = 0;
        while (i < tabList.size()) {
            Tab tab = (Tab)tabList.get(i);
            this.reflesh(tab.getText());
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.closeMenuItem) {
            this.closeAction(ev);
        } else if (ev.getSource() == this.sqlButton) {
            SqlConstants.DatabaseProduct databaseProduct = SqlConstants.DatabaseProduct.getById(this.profile.productId);
            XdtsCustomSql customSql = new XdtsCustomSql();
            XdtsDataViewPanel_Sql dataViewPanel = new XdtsDataViewPanel_Sql();
            dataViewPanel.setProfile(this.profile);
            dataViewPanel.setCustomSql(customSql);
            dataViewPanel.setTitle("SQL : " + this.profile.name + " [" + databaseProduct.productName + "]");
            dataViewPanel.init();
            dataViewPanel.showAsFrame();
        } else if (ev.getSource() == this.importButton) {
            XdtsDataImportWizard dataImportWizard = new XdtsDataImportWizard();
            dataImportWizard.show(this.profile, null);
        } else if (ev.getSource() == this.logicalNameCsvImportButton) {
            XdtsLogicalNameImportPane logicalNameImportPane = new XdtsLogicalNameImportPane(XdtsLogicalNameImportPane.Mode.import_, this.profile.getDataId());
            logicalNameImportPane.show(null, XdtsWords.getInstance().Logical_name_CSV_import);
        } else if (ev.getSource() == this.logicalNameCsvExportButton) {
            XdtsLogicalNameImportPane logicalNameImportPane = new XdtsLogicalNameImportPane(XdtsLogicalNameImportPane.Mode.export, this.profile.getDataId());
            logicalNameImportPane.show(null, XdtsWords.getInstance().Logical_name_CSV_export);
        } else if (ev.getSource() == this.logicalNameButton) {
            if (this.logicalNamePanel == null) {
                this.logicalNamePanel = new XdtsLogicalNamePanel();
            }
            this.logicalNamePanel.showAsFrame(this.profile);
        }
    }

    protected void closeAction(ActionEvent ev) throws Exception {
        this.close();
    }

    public void close() throws Exception {
        if (this.profileTreePane != null) {
            try {
                this.profileTreePane.destruct();
                XdtsProfileStub.getInstance().disconnect(this.profile.getDataId());
            }
            catch (Exception ex) {
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)ex.toString(), BcWords.getInstance().error, 0);
            }
        }
        this.stage.close();
        Object obj = BcInstanceManager.getInstance().remove(((Object)((Object)this)).getClass(), this.profile.getDataId());
    }

    protected void show(XdtsProfile profile, Window ownerWindow) throws Exception {
        this.setProfile(profile);
        this.init();
        this.setContents();
        this.createStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    XdtsProfilePane.this.setup();
                }
                catch (Exception ex) {
                    XdtsProfilePane.this.handleException(ex);
                }
            }
        });
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XdtsProfilePane.this.close();
                }
                catch (Exception ex) {
                    XdtsProfilePane.this.handleException(ex);
                }
            }
        });
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                double leftWidth = 240.0;
                double ratio = leftWidth / XdtsProfilePane.this.splitPane.getWidth();
                XdtsProfilePane.this.splitPane.setDividerPositions(new double[]{ratio});
            }
        });
        this.stage.setResizable(true);
        this.stage.setTitle(profile.name);
        Image image = FxImageHelper.getImage("db_64x64.png");
        this.stage.getIcons().add((Object)image);
        FxUtil.setWindowCenter((Window)this.stage, 0.8f);
        this.stage.show();
    }

    public static void show2(int profileId, Window ownerWindow) throws Exception {
        XdtsProfilePane profilePane = (XdtsProfilePane)((Object)BcInstanceManager.getInstance().get(XdtsProfilePane.class, profileId));
        if (profilePane != null) {
            profilePane.stage.toFront();
            return;
        }
        XdtsProfile profile = XdtsProfileStub.getInstance().getProfile(profileId);
        profilePane = new XdtsProfilePane();
        BcInstanceManager.getInstance().put(profileId, (Object)profilePane);
        profilePane.show(profile, ownerWindow);
    }

    class SetupTask
    extends TskAbstractCallable {
        SetupTask() {
        }

        public Object taskProcess() throws Exception {
            XdtsProfilePane.this.profile = XdtsProfileStub.getInstance().connectByProfileId(XdtsProfilePane.this.profile.getDataId());
            XdtsProfilePane.this.progressIndicationPane.msgLabel.setText(BcWords.getInstance().connectedTo(XdtsProfilePane.this.profile.name));
            XdtsProfilePane.this.wordManager = new DtsWordManagerImpl();
            List<EtcWord> wordList = XdtsWordStub.getInstance().getWordList(XdtsProfilePane.this.profile.getDataId());
            BcLogUtil.debug("Word List downloaded. size=" + wordList.size());
            EtcWordUtil.setWordCollection(XdtsProfilePane.this.wordManager, wordList);
            FxPlatform.runLater(new BcRunnable(){

                @Override
                public void run2() throws Exception {
                    ((SetupTask)SetupTask.this).XdtsProfilePane.this.progressIndicationPane.msgLabel.setText("\u30b9\u30ad\u30fc\u30de\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30c4\u30ea\u30fc\u3092\u5c55\u958b\u4e2d...");
                    ((SetupTask)SetupTask.this).XdtsProfilePane.this.profileTreePane = new XdtsProfileTreePane(XdtsProfilePane.this);
                    ((SetupTask)SetupTask.this).XdtsProfilePane.this.profileTreePane.treeView.setProfile(((SetupTask)SetupTask.this).XdtsProfilePane.this.profile, ((SetupTask)SetupTask.this).XdtsProfilePane.this.wordManager);
                    ((SetupTask)SetupTask.this).XdtsProfilePane.this.splitPane.getItems().clear();
                    ((SetupTask)SetupTask.this).XdtsProfilePane.this.splitPane.getItems().addAll((Object[])new Node[]{((SetupTask)SetupTask.this).XdtsProfilePane.this.profileTreePane, ((SetupTask)SetupTask.this).XdtsProfilePane.this.tabPane1});
                    SplitPane.setResizableWithParent((Node)((SetupTask)SetupTask.this).XdtsProfilePane.this.profileTreePane, (Boolean)Boolean.FALSE);
                }
            });
            return null;
        }

        @Override
        protected void handleException(Throwable throwable) {
            super.handleException(throwable);
            final String msg = BcExceptionUtil.getRoot(throwable).toString();
            FxPlatform.runLater(new BcRunnable(){

                @Override
                public void run2() throws Exception {
                    FxBorderPane borderPane = new FxBorderPane();
                    borderPane.setCenter((Node)new FxLabel(msg));
                    ((SetupTask)SetupTask.this).XdtsProfilePane.this.splitPane.getItems().clear();
                    ((SetupTask)SetupTask.this).XdtsProfilePane.this.splitPane.getItems().add((Object)borderPane);
                }
            });
        }
    }
}

