/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.module.xdts.common.XdtsConstants;

public class XdtsPersistence {
    public static File getFile(String tableColumnName) throws Exception {
        File tmpDir = AfbApplication.getInstance().getTempDir();
        File file = new File(tmpDir, tableColumnName);
        BcLogUtil.debug("getFile:file=" + file.getPath());
        return file;
    }

    public static void saveObject(String name, Serializable object) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream objos = new ObjectOutputStream(baos);
        objos.writeObject(object);
        objos.close();
        File file = XdtsPersistence.getFile(name);
        BcLogUtil.debug("saveObject:file=" + file.getPath());
        BcFileUtil.makeParent(file);
        BcFileUtil.save(file, baos.toByteArray());
    }

    public static Object readObject(String name) throws Exception {
        File file = XdtsPersistence.getFile(name);
        if (!file.exists()) {
            return null;
        }
        return XdtsPersistence.readObject(file);
    }

    public static Object readObject(File file) throws Exception {
        byte[] bytes = BcFileUtil.read(file);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream objis = new ObjectInputStream(bais);
        Object object = objis.readObject();
        return object;
    }

    public static List<File> getFileList(int profileId) throws Exception {
        File tmpDir = AfbApplication.getInstance().getTempDir();
        BcLogUtil.debug("tmpDir=" + tmpDir.getPath());
        File[] filesFile = tmpDir.listFiles();
        ArrayList<File> fileList = new ArrayList<File>();
        File[] fileArray = filesFile;
        int n = filesFile.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            BcLogUtil.debug("file=" + file.getPath());
            fileList.add(file);
            ++n2;
        }
        BcLogUtil.debug("fileList.size()=" + fileList.size());
        return fileList;
    }

    public static StringBuilder createPrefix(long profileId, XdtsConstants.Category category) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(profileId);
        sb.append("_");
        sb.append(category.name());
        return sb;
    }

    public static String createFileName(long profileId, XdtsConstants.Category category, String objectName, XdtsConstants.FileType fileType) throws Exception {
        StringBuilder sb = XdtsPersistence.createPrefix(profileId, category);
        sb.append("_[");
        sb.append(objectName);
        sb.append("]_");
        sb.append(fileType.name());
        sb.append(".jso");
        return sb.toString();
    }
}

